/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.exavior.dozed.config.DozedConfig;
import net.exavior.dozed.data.DashAttachment;
import net.exavior.dozed.data.DozedAttachments;
import net.exavior.dozed.data.JumpAttachment;
import net.exavior.dozed.data.SMAttachment;
import net.exavior.dozed.data.SlideAttachment;
import net.exavior.dozed.data.WallJumpAttachment;
import net.exavior.dozed.item.custom.CoreItem;
import net.exavior.dozed.item.custom.QuasarCoreItemItem;
import net.exavior.dozed.item.custom.StarCoreItemItem;
import net.exavior.dozed.item.custom.VoidCoreItemItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

@EventBusSubscriber(modid="dozed", value={Dist.CLIENT})
public class DozedGuiEvents {
    private static final ResourceLocation DASH_ZERO_ICON = ResourceLocation.fromNamespaceAndPath((String)"dozed", (String)"textures/gui/dash_zero_active.png");
    private static final ResourceLocation DASH_ONE_ICON = ResourceLocation.fromNamespaceAndPath((String)"dozed", (String)"textures/gui/dash_one_active.png");
    private static final ResourceLocation DASH_TWO_ICON = ResourceLocation.fromNamespaceAndPath((String)"dozed", (String)"textures/gui/dash_two_active.png");
    private static final ResourceLocation DASH_THREE_ICON = ResourceLocation.fromNamespaceAndPath((String)"dozed", (String)"textures/gui/dash_three_active.png");
    private static final ResourceLocation JUMP_ACTIVE = ResourceLocation.fromNamespaceAndPath((String)"dozed", (String)"textures/gui/jump_active.png");
    private static final ResourceLocation JUMP_INACTIVE = ResourceLocation.fromNamespaceAndPath((String)"dozed", (String)"textures/gui/jump_inactive.png");
    private static final ResourceLocation WALL_JUMP_ZERO_ICON = ResourceLocation.fromNamespaceAndPath((String)"dozed", (String)"textures/gui/wall_jump_zero_active.png");
    private static final ResourceLocation WALL_JUMP_ONE_ICON = ResourceLocation.fromNamespaceAndPath((String)"dozed", (String)"textures/gui/wall_jump_one_active.png");
    private static final ResourceLocation WALL_JUMP_TWO_ICON = ResourceLocation.fromNamespaceAndPath((String)"dozed", (String)"textures/gui/wall_jump_two_active.png");
    private static final ResourceLocation SKIP_INACTIVE = ResourceLocation.fromNamespaceAndPath((String)"dozed", (String)"textures/gui/skip_inactive.png");
    private static final ResourceLocation SKIP_ONE_ACTIVE = ResourceLocation.fromNamespaceAndPath((String)"dozed", (String)"textures/gui/skip_one_active.png");
    private static final ResourceLocation SKIP_TWO_ACTIVE = ResourceLocation.fromNamespaceAndPath((String)"dozed", (String)"textures/gui/skip_two_active.png");
    private static final ResourceLocation SKIP_THREE_ACTIVE = ResourceLocation.fromNamespaceAndPath((String)"dozed", (String)"textures/gui/skip_three_active.png");
    private static final Minecraft MC = Minecraft.getInstance();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    public static void onRenderGuiPostDash(RenderGuiEvent.Post event) {
        ResourceLocation dashIcon;
        PoseStack poseStack = event.getGuiGraphics().pose();
        int screenWidth = MC.getWindow().getGuiScaledWidth();
        int screenHeight = MC.getWindow().getGuiScaledHeight();
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        LocalPlayer player = DozedGuiEvents.MC.player;
        assert (player != null);
        int dashes = (Integer)player.getData(DozedAttachments.DASH_LEFT);
        if (!(((SMAttachment)player.getData(DozedAttachments.SM_SLOT)).getStack().getItem() instanceof CoreItem) || !((DashAttachment)player.getData(DozedAttachments.DASH_ENABLED)).isToggled) {
            return;
        }
        Item item = ((SMAttachment)player.getData(DozedAttachments.SM_SLOT)).getStack().getItem();
        if (!(item instanceof CoreItem)) return;
        CoreItem coreItem = (CoreItem)item;
        if (coreItem instanceof StarCoreItemItem || coreItem instanceof VoidCoreItemItem) {
            if (dashes >= 3) {
                player.setData(DozedAttachments.HORIZONTAL_MAX.get(), (Object)Math.clamp((long)((Integer)player.getData(DozedAttachments.HORIZONTAL_MAX.get()) + 1), 0, 21));
                if ((Integer)player.getData(DozedAttachments.HORIZONTAL_MAX.get()) > 20 && ((Boolean)DozedConfig.CLIENT.gui_fade_out.get()).booleanValue()) return;
                dashIcon = DASH_THREE_ICON;
            } else if (dashes == 2) {
                dashIcon = DASH_TWO_ICON;
                player.setData(DozedAttachments.HORIZONTAL_MAX.get(), (Object)0);
            } else if (dashes == 1) {
                dashIcon = DASH_ONE_ICON;
                player.setData(DozedAttachments.HORIZONTAL_MAX.get(), (Object)0);
            } else {
                dashIcon = DASH_ZERO_ICON;
                player.setData(DozedAttachments.HORIZONTAL_MAX.get(), (Object)0);
            }
        } else {
            if (!(coreItem instanceof QuasarCoreItemItem)) return;
            if (dashes >= 2) {
                player.setData(DozedAttachments.HORIZONTAL_MAX.get(), (Object)Math.clamp((long)((Integer)player.getData(DozedAttachments.HORIZONTAL_MAX.get()) + 1), 0, 21));
                if ((Integer)player.getData(DozedAttachments.HORIZONTAL_MAX.get()) > 20 && ((Boolean)DozedConfig.CLIENT.gui_fade_out.get()).booleanValue()) return;
                dashIcon = DASH_TWO_ICON;
            } else if (dashes == 1) {
                dashIcon = DASH_ONE_ICON;
                player.setData(DozedAttachments.HORIZONTAL_MAX.get(), (Object)0);
            } else {
                dashIcon = DASH_ZERO_ICON;
                player.setData(DozedAttachments.HORIZONTAL_MAX.get(), (Object)0);
            }
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.pushPose();
        poseStack.translate((float)(centerX - 7 + (Integer)DozedConfig.CLIENT.dashOffsetX.get()), (float)(centerY + 13 + (Integer)DozedConfig.CLIENT.dashOffsetY.get()), 0.0f);
        poseStack.scale(0.4f, 0.4f, 1.0f);
        MC.getTextureManager().bindForSetup(dashIcon);
        event.getGuiGraphics().blit(dashIcon, 0, 0, 0.0f, 0.0f, 32, 32, 32, 32);
        poseStack.popPose();
        RenderSystem.disableBlend();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    public static void onRenderGuiPostSkip(RenderGuiEvent.Post event) {
        ResourceLocation dashIcon;
        PoseStack poseStack = event.getGuiGraphics().pose();
        int screenWidth = MC.getWindow().getGuiScaledWidth();
        int screenHeight = MC.getWindow().getGuiScaledHeight();
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        LocalPlayer player = DozedGuiEvents.MC.player;
        assert (player != null);
        int skips = (Integer)player.getData(DozedAttachments.SKIP_LEFT);
        if (!(((SMAttachment)player.getData(DozedAttachments.SM_SLOT)).getStack().getItem() instanceof CoreItem) || !((SlideAttachment)player.getData(DozedAttachments.SKIP_ENABLED)).isToggled) {
            return;
        }
        Item item = ((SMAttachment)player.getData(DozedAttachments.SM_SLOT)).getStack().getItem();
        if (!(item instanceof CoreItem)) return;
        CoreItem coreItem = (CoreItem)item;
        if (coreItem instanceof StarCoreItemItem || coreItem instanceof VoidCoreItemItem) {
            if (skips >= 3) {
                player.setData(DozedAttachments.HORIZONTAL_MAX.get(), (Object)Math.clamp((long)((Integer)player.getData(DozedAttachments.HORIZONTAL_MAX.get()) + 1), 0, 21));
                if ((Integer)player.getData(DozedAttachments.HORIZONTAL_MAX.get()) > 20 && ((Boolean)DozedConfig.CLIENT.gui_fade_out.get()).booleanValue()) return;
                dashIcon = SKIP_THREE_ACTIVE;
            } else if (skips == 2) {
                dashIcon = SKIP_TWO_ACTIVE;
                player.setData(DozedAttachments.HORIZONTAL_MAX.get(), (Object)0);
            } else if (skips == 1) {
                dashIcon = SKIP_ONE_ACTIVE;
                player.setData(DozedAttachments.HORIZONTAL_MAX.get(), (Object)0);
            } else {
                dashIcon = SKIP_INACTIVE;
                player.setData(DozedAttachments.HORIZONTAL_MAX.get(), (Object)0);
            }
        } else {
            if (!(coreItem instanceof QuasarCoreItemItem)) return;
            if (skips >= 2) {
                player.setData(DozedAttachments.HORIZONTAL_MAX.get(), (Object)Math.clamp((long)((Integer)player.getData(DozedAttachments.HORIZONTAL_MAX.get()) + 1), 0, 21));
                if ((Integer)player.getData(DozedAttachments.HORIZONTAL_MAX.get()) > 20 && ((Boolean)DozedConfig.CLIENT.gui_fade_out.get()).booleanValue()) return;
                dashIcon = SKIP_TWO_ACTIVE;
            } else if (skips == 1) {
                dashIcon = SKIP_ONE_ACTIVE;
                player.setData(DozedAttachments.HORIZONTAL_MAX.get(), (Object)0);
            } else {
                dashIcon = SKIP_INACTIVE;
                player.setData(DozedAttachments.HORIZONTAL_MAX.get(), (Object)0);
            }
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.pushPose();
        poseStack.translate((float)(centerX - 8 + (Integer)DozedConfig.CLIENT.skipOffsetX.get()), (float)(centerY + 7 + (Integer)DozedConfig.CLIENT.skipOffsetY.get()), 0.0f);
        poseStack.scale(0.5f, 0.5f, 1.0f);
        MC.getTextureManager().bindForSetup(dashIcon);
        event.getGuiGraphics().blit(dashIcon, 0, 0, 0.0f, 0.0f, 32, 32, 32, 32);
        poseStack.popPose();
        RenderSystem.disableBlend();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    public static void onRenderGuiPostJump(RenderGuiEvent.Post event) {
        ResourceLocation jumpIcon;
        PoseStack poseStack = event.getGuiGraphics().pose();
        int screenWidth = MC.getWindow().getGuiScaledWidth();
        int screenHeight = MC.getWindow().getGuiScaledHeight();
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        LocalPlayer player = DozedGuiEvents.MC.player;
        assert (player != null);
        int jumps = (Integer)player.getData(DozedAttachments.JUMP_LEFT);
        if (!(((SMAttachment)player.getData(DozedAttachments.SM_SLOT)).getStack().getItem() instanceof CoreItem) || !((JumpAttachment)player.getData(DozedAttachments.JUMP_ENABLED)).isToggled) {
            return;
        }
        Item item = ((SMAttachment)player.getData(DozedAttachments.SM_SLOT)).getStack().getItem();
        if (!(item instanceof CoreItem)) return;
        CoreItem coreItem = (CoreItem)item;
        if (coreItem instanceof StarCoreItemItem || coreItem instanceof VoidCoreItemItem) {
            if (jumps >= 1) {
                player.setData(DozedAttachments.VERTICAL_MAX.get(), (Object)Math.clamp((long)((Integer)player.getData(DozedAttachments.VERTICAL_MAX.get()) + 1), 0, 21));
                if ((Integer)player.getData(DozedAttachments.VERTICAL_MAX.get()) > 20 && ((Boolean)DozedConfig.CLIENT.gui_fade_out.get()).booleanValue()) return;
                jumpIcon = JUMP_ACTIVE;
            } else {
                jumpIcon = JUMP_INACTIVE;
                player.setData(DozedAttachments.VERTICAL_MAX.get(), (Object)0);
            }
        } else {
            if (!(coreItem instanceof QuasarCoreItemItem)) return;
            if (jumps >= 1) {
                player.setData(DozedAttachments.VERTICAL_MAX.get(), (Object)Math.clamp((long)((Integer)player.getData(DozedAttachments.VERTICAL_MAX.get()) + 1), 0, 21));
                if ((Integer)player.getData(DozedAttachments.VERTICAL_MAX.get()) > 20 && ((Boolean)DozedConfig.CLIENT.gui_fade_out.get()).booleanValue()) return;
                jumpIcon = JUMP_ACTIVE;
            } else {
                jumpIcon = JUMP_INACTIVE;
                player.setData(DozedAttachments.VERTICAL_MAX.get(), (Object)0);
            }
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.pushPose();
        poseStack.translate((float)(centerX + 5 + (Integer)DozedConfig.CLIENT.jumpOffsetX.get()), (float)(centerY - 7 + (Integer)DozedConfig.CLIENT.jumpOffsetY.get()), 0.0f);
        poseStack.scale(0.4f, 0.4f, 1.0f);
        MC.getTextureManager().bindForSetup(jumpIcon);
        event.getGuiGraphics().blit(jumpIcon, 0, 0, 0.0f, 0.0f, 32, 32, 32, 32);
        poseStack.popPose();
        RenderSystem.disableBlend();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    public static void onRenderGuiPostWallJump(RenderGuiEvent.Post event) {
        ResourceLocation walljumpIcon;
        PoseStack poseStack = event.getGuiGraphics().pose();
        int screenWidth = MC.getWindow().getGuiScaledWidth();
        int screenHeight = MC.getWindow().getGuiScaledHeight();
        int centerX = screenWidth / 2;
        int centerY = screenHeight / 2;
        LocalPlayer player = DozedGuiEvents.MC.player;
        assert (player != null);
        int jump = (Integer)player.getData(DozedAttachments.WALL_JUMP_LEFT);
        if (!(((SMAttachment)player.getData(DozedAttachments.SM_SLOT)).getStack().getItem() instanceof CoreItem) || !((WallJumpAttachment)player.getData(DozedAttachments.WALL_JUMP_ENABLED)).isToggled) {
            return;
        }
        Item item = ((SMAttachment)player.getData(DozedAttachments.SM_SLOT)).getStack().getItem();
        if (!(item instanceof CoreItem)) return;
        CoreItem coreItem = (CoreItem)item;
        if (coreItem instanceof StarCoreItemItem || coreItem instanceof VoidCoreItemItem) {
            if (jump >= 2) {
                player.setData(DozedAttachments.VERTICAL_MAX.get(), (Object)Math.clamp((long)((Integer)player.getData(DozedAttachments.VERTICAL_MAX.get()) + 1), 0, 21));
                if ((Integer)player.getData(DozedAttachments.VERTICAL_MAX.get()) > 20 && ((Boolean)DozedConfig.CLIENT.gui_fade_out.get()).booleanValue()) return;
                walljumpIcon = WALL_JUMP_TWO_ICON;
            } else if (jump == 1) {
                walljumpIcon = WALL_JUMP_ONE_ICON;
                player.setData(DozedAttachments.VERTICAL_MAX.get(), (Object)0);
            } else {
                walljumpIcon = WALL_JUMP_ZERO_ICON;
                player.setData(DozedAttachments.VERTICAL_MAX.get(), (Object)0);
            }
        } else {
            if (!(coreItem instanceof QuasarCoreItemItem)) return;
            if (jump >= 1) {
                player.setData(DozedAttachments.VERTICAL_MAX.get(), (Object)Math.clamp((long)((Integer)player.getData(DozedAttachments.VERTICAL_MAX.get()) + 1), 0, 21));
                if ((Integer)player.getData(DozedAttachments.VERTICAL_MAX.get()) > 20 && ((Boolean)DozedConfig.CLIENT.gui_fade_out.get()).booleanValue()) return;
                walljumpIcon = WALL_JUMP_ONE_ICON;
            } else {
                walljumpIcon = WALL_JUMP_ZERO_ICON;
                player.setData(DozedAttachments.VERTICAL_MAX.get(), (Object)0);
            }
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.pushPose();
        poseStack.translate((float)(centerX + 6 + (Integer)DozedConfig.CLIENT.walljumpOffsetX.get()), (float)(centerY - 5 + (Integer)DozedConfig.CLIENT.walljumpOffsetY.get()), 0.0f);
        poseStack.scale(0.38f, 0.38f, 1.0f);
        MC.getTextureManager().bindForSetup(walljumpIcon);
        event.getGuiGraphics().blit(walljumpIcon, 0, 0, 0.0f, 0.0f, 32, 32, 32, 32);
        poseStack.popPose();
        RenderSystem.disableBlend();
    }
}

