/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.gui.screen;

import net.exavior.dozed.data.DashAttachment;
import net.exavior.dozed.data.DozedAttachments;
import net.exavior.dozed.data.JumpAttachment;
import net.exavior.dozed.data.SlideAttachment;
import net.exavior.dozed.data.WallJumpAttachment;
import net.exavior.dozed.network.client.packets.CToggleDashPacket;
import net.exavior.dozed.network.client.packets.CToggleJumpPacket;
import net.exavior.dozed.network.client.packets.CToggleSlidePacket;
import net.exavior.dozed.network.client.packets.CToggleWallJumpPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.realms.RealmsLabel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class SMScreen
extends Screen {
    private static final int IMAGE_WIDTH = 176;
    private static final int IMAGE_HEIGHT = 166;
    private int leftPos;
    private int topPos;
    private final Player owner;
    private final ItemStack stack;
    private AbstractButton dashButton;
    private AbstractButton skipButton;
    private AbstractButton jumpButton;
    private AbstractButton walljumpButton;

    public SMScreen(Player owner, ItemStack stack) {
        super((Component)Component.literal((String)"Star Motion Controls"));
        this.owner = owner;
        this.stack = stack;
    }

    public void setScreen() {
        Minecraft.getInstance().setScreen((Screen)new SMScreen(this.owner, this.stack));
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - 176) / 2;
        this.topPos = (this.height - 166) / 2;
        this.addRenderableOnly((Renderable)new RealmsLabel((Component)Component.literal((String)"Vertical"), this.leftPos + 24 + 16, this.topPos + 50, -1));
        this.addRenderableOnly((Renderable)new RealmsLabel((Component)Component.literal((String)"Horizontal"), this.leftPos + 24 + 32 + 80, this.topPos + 50, -1));
        this.dashButton = (AbstractButton)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("Dash: " + ((DashAttachment)this.owner.getData(DozedAttachments.DASH_ENABLED)).isToggled)), button -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new CToggleDashPacket(this.stack, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            button.setMessage((Component)Component.literal((String)("Dash: " + !((DashAttachment)this.owner.getData(DozedAttachments.DASH_ENABLED)).isToggled)));
            this.skipButton.setMessage((Component)Component.literal((String)"Skip: false"));
        }).bounds(this.leftPos + 16 + 80, this.topPos + 120, 80, 16).build());
        this.skipButton = (AbstractButton)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("Skip: " + ((SlideAttachment)this.owner.getData(DozedAttachments.SKIP_ENABLED)).isToggled)), button -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new CToggleSlidePacket(this.stack, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            button.setMessage((Component)Component.literal((String)("Skip: " + !((SlideAttachment)this.owner.getData(DozedAttachments.SKIP_ENABLED)).isToggled)));
            this.dashButton.setMessage((Component)Component.literal((String)"Dash: false"));
        }).bounds(this.leftPos + 16 + 80, this.topPos + 96, 80, 16).build());
        this.jumpButton = (AbstractButton)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("Jump: " + ((JumpAttachment)this.owner.getData(DozedAttachments.JUMP_ENABLED)).isToggled)), button -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new CToggleJumpPacket(this.stack, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            button.setMessage((Component)Component.literal((String)("Jump: " + !((JumpAttachment)this.owner.getData(DozedAttachments.JUMP_ENABLED)).isToggled)));
            this.walljumpButton.setMessage((Component)Component.literal((String)"Wall Jump: false"));
        }).bounds(this.leftPos, this.topPos + 120, 80, 16).build());
        this.walljumpButton = (AbstractButton)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)("Wall Jump: " + ((WallJumpAttachment)this.owner.getData(DozedAttachments.WALL_JUMP_ENABLED)).isToggled)), button -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new CToggleWallJumpPacket(this.stack, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            button.setMessage((Component)Component.literal((String)("Wall Jump: " + !((WallJumpAttachment)this.owner.getData(DozedAttachments.WALL_JUMP_ENABLED)).isToggled)));
            this.jumpButton.setMessage((Component)Component.literal((String)"Jump: false"));
        }).bounds(this.leftPos, this.topPos + 96, 80, 16).build());
    }
}

