/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.item.custom;

import java.util.List;
import net.exavior.dozed.entity.DozedEntityTypes;
import net.exavior.dozed.entity.custom.FallingStarProjectileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class CrescentBladeItem
extends Item {
    private static final int DEFAULT_ATTACK_DAMAGE = 5;
    private static final double DEFAULT_ATTACK_SPEED = -2.2;

    public CrescentBladeItem(Item.Properties properties) {
        super(properties);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 5.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.2, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 0);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() instanceof CrescentBladeItem) {
            ItemStack offStack = player.getOffhandItem();
            if (offStack.getItem() instanceof CrescentBladeItem && player.getMainHandItem().getItem() instanceof CrescentBladeItem) {
                if (!level.isClientSide() && !level.isClientSide()) {
                    Vec3 playerView = player.getLookAngle();
                    Vec3 up = new Vec3(0.0, 1.0, 0.0);
                    Vec3 rightVec = playerView.cross(up).normalize().scale(1.0);
                    Vec3 leftVec = rightVec.scale(-1.0);
                    FallingStarProjectileEntity leftProjectile = new FallingStarProjectileEntity((EntityType<? extends Projectile>)((EntityType)DozedEntityTypes.FALLING_STAR_PROJECTILE_ENTITY.get()), level);
                    leftProjectile.setOwner((Entity)player);
                    leftProjectile.setInvTime(13);
                    leftProjectile.setPos(player.getX() + leftVec.x, player.getEyeY() - 0.3, player.getZ() + leftVec.z);
                    leftProjectile.shoot(playerView.x, playerView.y, playerView.z, 1.8f, 0.0f);
                    level.addFreshEntity((Entity)leftProjectile);
                    FallingStarProjectileEntity rightProjectile = new FallingStarProjectileEntity((EntityType<? extends Projectile>)((EntityType)DozedEntityTypes.FALLING_STAR_PROJECTILE_ENTITY.get()), level);
                    rightProjectile.setOwner((Entity)player);
                    rightProjectile.setInvTime(13);
                    rightProjectile.setPos(player.getX() + rightVec.x, player.getEyeY() - 0.3, player.getZ() + rightVec.z);
                    rightProjectile.shoot(playerView.x, playerView.y, playerView.z, 1.8f, 0.0f);
                    level.addFreshEntity((Entity)rightProjectile);
                }
            } else if (!level.isClientSide()) {
                FallingStarProjectileEntity projectile = new FallingStarProjectileEntity((EntityType<? extends Projectile>)((EntityType)DozedEntityTypes.FALLING_STAR_PROJECTILE_ENTITY.get()), level);
                Vec3 playerView = player.getLookAngle();
                projectile.setOwner((Entity)player);
                projectile.setInvTime(18);
                projectile.setPos(player.getX(), player.getEyeY() - 0.3, player.getZ());
                projectile.shoot(playerView.x, playerView.y, playerView.z, 1.8f, 0.0f);
                level.addFreshEntity((Entity)projectile);
            }
            player.playSound((SoundEvent)SoundEvents.TRIDENT_THROW.value(), 0.4f, 0.7f);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(level, player, hand);
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"Test"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

