/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.item.custom;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CrystalAlloyItem
extends Item {
    public CrystalAlloyItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        player.startUsingItem(usedHand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (!level.isClientSide() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (level.isNight()) {
                Vec3 playerView = player.getLookAngle();
                if (level.canSeeSky(player.getOnPos().above())) {
                    double total = 0.0;
                    double playerY = Math.PI * playerView.y;
                    double sunAngle = level.getSunAngle(level.getDayTimePerTick());
                    System.out.println("Y-Level: " + playerView.y);
                    System.out.println("Y-Level Pi: " + playerY);
                    System.out.println("Sun Angle: " + sunAngle);
                    if (sunAngle > 3.151592653589793) {
                        System.out.println("Sun Angle True");
                        total += Math.PI * (1.0 - playerView.y);
                    }
                    System.out.println("Total Angle: " + (total += playerY));
                    if (Math.abs(total - sunAngle) <= 0.2) {
                        System.out.println("Looking at Moon");
                    }
                }
            }
        }
        super.onUseTick(level, livingEntity, stack, remainingUseDuration);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }
}

