/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.item.custom;

import net.exavior.dozed.entity.custom.EnderLightEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class EnderLightItem
extends Item {
    public EnderLightItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDER_PEARL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        player.getCooldowns().addCooldown((Item)this, 30);
        if (!level.isClientSide) {
            EnderLightEntity thrownenderpearl = new EnderLightEntity(level, (LivingEntity)player);
            thrownenderpearl.setItem(itemstack);
            thrownenderpearl.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.4f, 1.0f);
            level.addFreshEntity((Entity)thrownenderpearl);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        itemstack.consume(1, (LivingEntity)player);
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
    }
}

