/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.item.custom;

import java.util.List;
import java.util.Optional;
import net.exavior.dozed.entity.DozedEntityTypes;
import net.exavior.dozed.entity.custom.LightAwryEntity;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class LightAwryItem
extends Item {
    public LightAwryItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (!level.isClientSide) {
            Vec3 start = player.getEyePosition();
            Vec3 look = player.getLookAngle();
            double distance = 30.0;
            Vec3 end = start.add(look.scale(distance));
            AABB boundingBox = new AABB(start, end).inflate(2.0);
            List entities = level.getEntities((Entity)player, boundingBox, entity -> entity instanceof LivingEntity);
            LivingEntity closestEntity = null;
            double closestDistance = Double.MAX_VALUE;
            for (Entity entity2 : entities) {
                double distanceToHit;
                AABB entityBox = entity2.getBoundingBox().inflate(0.5);
                Optional optionalHit = entityBox.clip(start, end);
                if (!optionalHit.isPresent() || !((distanceToHit = start.distanceTo((Vec3)optionalHit.get())) < closestDistance)) continue;
                closestDistance = distanceToHit;
                closestEntity = (LivingEntity)entity2;
            }
            if (closestEntity != null) {
                LightAwryEntity lightAwry = new LightAwryEntity((EntityType<? extends Projectile>)((EntityType)DozedEntityTypes.LIGHT_AWRY_PROJECTILE_ENTITY.get()), level);
                lightAwry.setTarget(closestEntity);
                RandomSource random = player.getRandom();
                int ranNum = random.nextInt(0, 2);
                Vec3 playerView = player.getLookAngle();
                if (ranNum == 0) {
                    Vec3 leftVec = new Vec3(-playerView.z, 0.0, playerView.x).normalize().scale(1.0);
                    lightAwry.setPos(player.getX() + leftVec.x, player.getEyeY() - 0.5, player.getZ() + leftVec.z);
                    lightAwry.addDeltaMovement(new Vec3(leftVec.x * 0.3, 0.3, leftVec.z * 0.3));
                } else if (ranNum == 1) {
                    Vec3 rightVec = new Vec3(playerView.z, 0.0, -playerView.x).normalize().scale(1.0);
                    lightAwry.setPos(player.getX() + rightVec.x, player.getEyeY() - 0.5, player.getZ() + rightVec.z);
                    lightAwry.addDeltaMovement(new Vec3(rightVec.x * 0.3, 0.3, rightVec.z * 0.3));
                }
                level.addFreshEntity((Entity)lightAwry);
                stack.shrink(1);
                player.getCooldowns().addCooldown(stack.getItem(), 20);
                return InteractionResultHolder.success((Object)stack);
            }
        }
        return super.use(level, player, usedHand);
    }
}

