/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.mixin;

import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrossbowItem.class})
public abstract class CrossBowUseMixin {
    @Shadow
    public abstract Predicate<ItemStack> getSupportedHeldProjectiles();

    @Inject(method={"getSupportedHeldProjectiles"}, at={@At(value="RETURN")}, cancellable=true)
    public void dozed_load_enderpearl(CallbackInfoReturnable<Predicate<ItemStack>> cir) {
        Predicate originalPredicate = (Predicate)cir.getReturnValue();
        Predicate<ItemStack> augmentedPredicate = originalPredicate.or(itemStack -> itemStack.getItem() instanceof EnderpearlItem);
        cir.setReturnValue(augmentedPredicate);
    }

    @Inject(method={"createProjectile"}, at={@At(value="RETURN")}, cancellable=true)
    public void dozed_create_enderpearl(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, boolean isCrit, CallbackInfoReturnable<Projectile> cir) {
        if (ammo.is(Items.ENDER_PEARL)) {
            cir.setReturnValue((Object)new ThrownEnderpearl(level, shooter));
        }
    }
}

