/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.network.client;

import net.exavior.dozed.Dozed;
import net.exavior.dozed.data.DashAttachment;
import net.exavior.dozed.data.DozedAttachments;
import net.exavior.dozed.data.JumpAttachment;
import net.exavior.dozed.data.SlideAttachment;
import net.exavior.dozed.data.WallJumpAttachment;
import net.exavior.dozed.network.server.packets.SDoAddVelocityToClient;
import net.exavior.dozed.network.server.packets.SPacketSyncToggleDash;
import net.exavior.dozed.network.server.packets.SPacketSyncToggleJump;
import net.exavior.dozed.network.server.packets.SPacketSyncToggleSlide;
import net.exavior.dozed.network.server.packets.SPacketSyncToggleWallJump;
import net.exavior.dozed.network.server.packets.STCAddDashRegenPacket;
import net.exavior.dozed.network.server.packets.STCAddJumpRegenPacket;
import net.exavior.dozed.network.server.packets.STCAddSkipRegenPacket;
import net.exavior.dozed.network.server.packets.STCAddWallJumpRegenPacket;
import net.exavior.dozed.network.server.packets.STCSkipFallPacketSent;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class DozedClientPayloadHandler {
    private static final DozedClientPayloadHandler INSTANCE = new DozedClientPayloadHandler();

    public static DozedClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    private static void handle(IPayloadContext ctx, Runnable task) {
        ctx.enqueueWork(task).exceptionally(e -> {
            Dozed.LOGGER.error("Failed to handle packet: ", e);
            return null;
        });
    }

    public void handleToggleDash(SPacketSyncToggleDash data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            ((DashAttachment)player.getData(DozedAttachments.DASH_ENABLED)).isToggled = data.toggled();
            if (data.toggled()) {
                ((SlideAttachment)player.getData(DozedAttachments.SKIP_ENABLED)).isToggled = false;
            }
        });
    }

    public void handleToggleSlide(SPacketSyncToggleSlide data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            ((SlideAttachment)player.getData(DozedAttachments.SKIP_ENABLED)).isToggled = data.toggled();
            if (data.toggled()) {
                ((DashAttachment)player.getData(DozedAttachments.DASH_ENABLED)).isToggled = false;
            }
        });
    }

    public void handleToggleJump(SPacketSyncToggleJump data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            ((JumpAttachment)player.getData(DozedAttachments.JUMP_ENABLED)).isToggled = data.toggled();
            if (data.toggled()) {
                ((WallJumpAttachment)player.getData(DozedAttachments.WALL_JUMP_ENABLED)).isToggled = false;
            }
        });
    }

    public void handleToggleWallJump(SPacketSyncToggleWallJump data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            ((WallJumpAttachment)player.getData(DozedAttachments.WALL_JUMP_ENABLED)).isToggled = data.toggled();
            if (data.toggled()) {
                ((JumpAttachment)player.getData(DozedAttachments.JUMP_ENABLED)).isToggled = false;
            }
        });
    }

    public void handleSkipFallHappenSync(STCSkipFallPacketSent data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            player.setData(DozedAttachments.SKIP_FALL_PACKET_SENT, (Object)false);
        });
    }

    public void handleAddVelocityToClient(SDoAddVelocityToClient data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            player.push(0.0, (double)0.15f, 0.0);
        });
    }

    public void handleAddDashRegenToClient(STCAddDashRegenPacket data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            player.setData(DozedAttachments.DASH_REGEN, (Object)((Integer)player.getData(DozedAttachments.DASH_REGEN) + data.addedRegen()));
        });
    }

    public void handleAddSkipRegenToClient(STCAddSkipRegenPacket data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            player.setData(DozedAttachments.SKIP_REGEN, (Object)((Integer)player.getData(DozedAttachments.SKIP_REGEN) + data.addedRegen()));
        });
    }

    public void handleAddJumpRegenToClient(STCAddJumpRegenPacket data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            player.setData(DozedAttachments.JUMP_REGEN, (Object)((Integer)player.getData(DozedAttachments.JUMP_REGEN) + data.addedRegen()));
        });
    }

    public void handleAddWallJumpRegenToClient(STCAddWallJumpRegenPacket data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            player.setData(DozedAttachments.WALL_JUMP_REGEN, (Object)((Integer)player.getData(DozedAttachments.WALL_JUMP_REGEN) + data.addedRegen()));
        });
    }
}

