/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.dozed.network.server;

import java.util.Iterator;
import net.exavior.dozed.data.DashAttachment;
import net.exavior.dozed.data.DozedAttachments;
import net.exavior.dozed.data.JumpAttachment;
import net.exavior.dozed.data.SlideAttachment;
import net.exavior.dozed.data.WallJumpAttachment;
import net.exavior.dozed.network.client.packets.CDoDashPacket;
import net.exavior.dozed.network.client.packets.CDoJumpPacket;
import net.exavior.dozed.network.client.packets.CDoWallJumpPacket;
import net.exavior.dozed.network.client.packets.CPacketSetDistance;
import net.exavior.dozed.network.client.packets.CPacketSyncSlamFall;
import net.exavior.dozed.network.client.packets.CPacketSyncSlideFall;
import net.exavior.dozed.network.client.packets.CTSGiveITicksPacket;
import net.exavior.dozed.network.client.packets.CTSPlayerHealthQuasarPacket;
import net.exavior.dozed.network.client.packets.CToggleDashPacket;
import net.exavior.dozed.network.client.packets.CToggleJumpPacket;
import net.exavior.dozed.network.client.packets.CToggleSlidePacket;
import net.exavior.dozed.network.client.packets.CToggleWallJumpPacket;
import net.exavior.dozed.network.server.packets.SPacketSyncToggleDash;
import net.exavior.dozed.network.server.packets.SPacketSyncToggleJump;
import net.exavior.dozed.network.server.packets.SPacketSyncToggleSlide;
import net.exavior.dozed.network.server.packets.SPacketSyncToggleWallJump;
import net.exavior.dozed.network.server.packets.STCSkipFallPacketSent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class DozedServerPayloadHandler {
    private static final DozedServerPayloadHandler INSTANCE = new DozedServerPayloadHandler();

    public static DozedServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleServerPlayerDoDash(CDoDashPacket data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (((DashAttachment)player.getData(DozedAttachments.DASH_ENABLED)).isToggled) {
                    int wKey = data.w();
                    int sKey = data.s();
                    int aKey = data.a();
                    int dKey = data.d();
                    int totalKeys = wKey + sKey + aKey + dKey;
                    System.out.println("Total Keys for Dash: " + totalKeys);
                    int playerDashes = (Integer)player.getData(DozedAttachments.DASH_LEFT);
                    if (playerDashes > 0) {
                        System.out.println("Dash");
                        Vec3 playerView = player.getLookAngle();
                        double totalPushX = 0.0;
                        double totalPushZ = 0.0;
                        if (totalKeys > 0) {
                            Vec3 scaledView;
                            if (wKey == 1) {
                                scaledView = playerView.normalize().scale(1.7);
                                totalPushX += scaledView.x;
                                totalPushZ += scaledView.z;
                            }
                            if (aKey == 1) {
                                Vec3 leftward = new Vec3(playerView.z, 0.0, -playerView.x).normalize().scale(1.7);
                                totalPushX += leftward.x;
                                totalPushZ += leftward.z;
                            }
                            if (dKey == 1) {
                                Vec3 rightward = new Vec3(-playerView.z, 0.0, playerView.x).normalize().scale(1.7);
                                totalPushX += rightward.x;
                                totalPushZ += rightward.z;
                            }
                            if (sKey == 1) {
                                scaledView = playerView.normalize().scale(-1.7);
                                totalPushX += scaledView.x;
                                totalPushZ += scaledView.z;
                            }
                            totalPushX /= (double)totalKeys;
                            totalPushZ /= (double)totalKeys;
                            player.setDeltaMovement(0.0, 0.0, 0.0);
                            player.fallDistance = 0.0f;
                            player.setData(DozedAttachments.DASH_LEFT, (Object)((Integer)player.getData(DozedAttachments.DASH_LEFT) - 1));
                            player.playSound((SoundEvent)SoundEvents.WIND_CHARGE_BURST.value(), 0.6f, 0.8f);
                            if (playerView.y > 0.0 && sKey == 0) {
                                scaledView = playerView.normalize().scale(0.4);
                                player.push(totalPushX, scaledView.y + 0.3, totalPushZ);
                            } else if (sKey == 1) {
                                scaledView = playerView.normalize().scale(0.4);
                                player.push(totalPushX, -scaledView.y + 0.3, totalPushZ);
                            } else {
                                player.push(totalPushX, playerView.y, totalPushZ);
                            }
                        }
                    }
                }
            }
        });
    }

    public void handleServerPlayerDoJump(CDoJumpPacket data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                int playerJumps;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!player.onGround() && !player.isInLiquid() && ((JumpAttachment)player.getData(DozedAttachments.JUMP_ENABLED)).isToggled && (playerJumps = ((Integer)player.getData(DozedAttachments.JUMP_LEFT)).intValue()) > 0) {
                    Vec3 scaledView;
                    int wKey = data.w();
                    int sKey = data.s();
                    int aKey = data.a();
                    int dKey = data.d();
                    int totalKeys = wKey + sKey + aKey + dKey;
                    Vec3 deltaM = player.getDeltaMovement();
                    double totalPushX = 0.0;
                    double totalPushZ = 0.0;
                    Vec3 playerView = player.getLookAngle();
                    if (totalKeys > 0) {
                        if (wKey == 1) {
                            scaledView = playerView.normalize().scale(0.3);
                            totalPushX += scaledView.x;
                            totalPushZ += scaledView.z;
                        }
                        if (aKey == 1) {
                            Vec3 leftward = new Vec3(playerView.z, 0.0, -playerView.x).normalize().scale(0.3);
                            totalPushX += leftward.x;
                            totalPushZ += leftward.z;
                        }
                        if (dKey == 1) {
                            Vec3 rightward = new Vec3(-playerView.z, 0.0, playerView.x).normalize().scale(0.3);
                            totalPushX += rightward.x;
                            totalPushZ += rightward.z;
                        }
                        if (sKey == 1) {
                            scaledView = playerView.normalize().scale(-0.3);
                            totalPushX += scaledView.x;
                            totalPushZ += scaledView.z;
                        }
                    }
                    totalPushX /= (double)totalKeys;
                    totalPushZ /= (double)totalKeys;
                    player.setDeltaMovement(0.0, 0.0, 0.0);
                    player.fallDistance = 0.0f;
                    player.setData(DozedAttachments.JUMP_LEFT, (Object)((Integer)player.getData(DozedAttachments.JUMP_LEFT) - 1));
                    player.playSound((SoundEvent)SoundEvents.WIND_CHARGE_BURST.value(), 0.6f, 1.3f);
                    if (player.getLookAngle().y > 0.0) {
                        scaledView = playerView.normalize().scale(0.3);
                        player.push(totalPushX + deltaM.x, scaledView.y + 0.7, totalPushZ + deltaM.z);
                    } else {
                        player.push(totalPushX + deltaM.x, 0.7, totalPushZ + deltaM.z);
                    }
                }
            }
        });
    }

    public void handleServerPlayerDoWallJump(CDoWallJumpPacket data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                int playerJumps;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!player.onGround() && !player.isInLiquid() && ((WallJumpAttachment)player.getData(DozedAttachments.WALL_JUMP_ENABLED)).isToggled && (playerJumps = ((Integer)player.getData(DozedAttachments.WALL_JUMP_LEFT)).intValue()) > 0) {
                    AABB aabb = player.getBoundingBox().inflate(0.5, 0.0, 0.5);
                    Iterable collisions = player.level().getBlockCollisions((Entity)player, aabb);
                    boolean hasCollision = false;
                    Iterator iterator = collisions.iterator();
                    if (iterator.hasNext()) {
                        VoxelShape voxelShape = (VoxelShape)iterator.next();
                        hasCollision = true;
                    }
                    if (hasCollision) {
                        int wKey = data.w();
                        int sKey = data.s();
                        int aKey = data.a();
                        int dKey = data.d();
                        int totalKeys = wKey + sKey + aKey + dKey;
                        Vec3 deltaM = player.getDeltaMovement();
                        double totalPushX = 0.0;
                        double totalPushZ = 0.0;
                        Vec3 playerView = player.getLookAngle();
                        if (totalKeys > 0) {
                            Vec3 scaledView;
                            if (wKey == 1) {
                                scaledView = playerView.normalize().scale(0.3);
                                totalPushX += scaledView.x;
                                totalPushZ += scaledView.z;
                            }
                            if (aKey == 1) {
                                Vec3 leftward = new Vec3(playerView.z, 0.0, -playerView.x).normalize().scale(0.3);
                                totalPushX += leftward.x;
                                totalPushZ += leftward.z;
                            }
                            if (dKey == 1) {
                                Vec3 rightward = new Vec3(-playerView.z, 0.0, playerView.x).normalize().scale(0.3);
                                totalPushX += rightward.x;
                                totalPushZ += rightward.z;
                            }
                            if (sKey == 1) {
                                scaledView = playerView.normalize().scale(-0.3);
                                totalPushX += scaledView.x;
                                totalPushZ += scaledView.z;
                            }
                        }
                        player.setDeltaMovement(0.0, 0.0, 0.0);
                        player.setData(DozedAttachments.WALL_JUMP_LEFT, (Object)((Integer)player.getData(DozedAttachments.WALL_JUMP_LEFT) - 1));
                        player.playSound((SoundEvent)SoundEvents.WIND_CHARGE_BURST.value(), 0.6f, 1.3f);
                        if (playerView.y > 0.0) {
                            double scaledView = playerView.y * 0.15;
                            player.push(totalPushX + deltaM.x, 0.8 + scaledView, totalPushZ + deltaM.z);
                        } else {
                            player.push(totalPushX + deltaM.x, 0.8, totalPushZ + deltaM.z);
                        }
                    }
                }
            }
        });
    }

    public void handleToggleDash(CToggleDashPacket data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                boolean isToggled = ((DashAttachment)serverPlayer.getData(DozedAttachments.DASH_ENABLED)).isToggled;
                ((DashAttachment)serverPlayer.getData(DozedAttachments.DASH_ENABLED)).isToggled = isToggled = !isToggled;
                ((SlideAttachment)serverPlayer.getData(DozedAttachments.SKIP_ENABLED)).isToggled = false;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SPacketSyncToggleDash(isToggled), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    public void handleToggleSlide(CToggleSlidePacket data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                boolean isToggled = ((SlideAttachment)serverPlayer.getData(DozedAttachments.SKIP_ENABLED)).isToggled;
                ((SlideAttachment)serverPlayer.getData(DozedAttachments.SKIP_ENABLED)).isToggled = isToggled = !isToggled;
                ((DashAttachment)serverPlayer.getData(DozedAttachments.DASH_ENABLED)).isToggled = false;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SPacketSyncToggleSlide(isToggled), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    public void handleToggleJump(CToggleJumpPacket data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                boolean isToggled = ((JumpAttachment)serverPlayer.getData(DozedAttachments.JUMP_ENABLED)).isToggled;
                ((JumpAttachment)serverPlayer.getData(DozedAttachments.JUMP_ENABLED)).isToggled = isToggled = !isToggled;
                ((WallJumpAttachment)serverPlayer.getData(DozedAttachments.WALL_JUMP_ENABLED)).isToggled = false;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SPacketSyncToggleJump(isToggled), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    public void handleToggleWallJump(CToggleWallJumpPacket data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                boolean isToggled = ((WallJumpAttachment)serverPlayer.getData(DozedAttachments.WALL_JUMP_ENABLED)).isToggled;
                ((WallJumpAttachment)serverPlayer.getData(DozedAttachments.WALL_JUMP_ENABLED)).isToggled = isToggled = !isToggled;
                ((JumpAttachment)serverPlayer.getData(DozedAttachments.JUMP_ENABLED)).isToggled = false;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SPacketSyncToggleWallJump(isToggled), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        });
    }

    public void handleSlideFallSync(CPacketSyncSlideFall data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.setData(DozedAttachments.SKIP_FALL_HAPPEN, (Object)true);
            }
        });
    }

    public void handleSlamFallSync(CPacketSyncSlamFall data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.setData(DozedAttachments.SLAM_HAPPEN, (Object)true);
            }
        });
    }

    public void handleSetDelta(CPacketSetDistance data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.setData(DozedAttachments.JUMP_STORAGE, (Object)data.distance());
            }
        });
    }

    public void handleQuasarSetHealth(CTSPlayerHealthQuasarPacket data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!player.hasInfiniteMaterials()) {
                    if (serverPlayer.getHealth() - serverPlayer.getMaxHealth() / 4.0f <= 0.0f) {
                        serverPlayer.kill();
                    }
                    serverPlayer.setHealth(serverPlayer.getHealth() - serverPlayer.getMaxHealth() / 4.0f);
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new STCSkipFallPacketSent(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        });
    }

    public void handleGiveInvincibilityTicks(CTSGiveITicksPacket data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                int ticks = data.ticks();
                if (serverPlayer.invulnerableTime < ticks) {
                    serverPlayer.invulnerableTime = ticks;
                }
            }
        });
    }
}

