/*
 * Decompiled with CFR 0.152.
 */
package net.robin.scpc.init;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.robin.scpc.entity.SCP131BEntity;
import net.robin.scpc.entity.SCP131Entity;
import net.robin.scpc.entity.SCP457Entity;
import net.robin.scpc.entity.SeatEntity;
import net.robin.scpc.entity.TestEntityEntity;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ScpContainedModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"scp_contained");
    public static final RegistryObject<EntityType<SeatEntity>> SEAT = ScpContainedModEntities.register("seat", EntityType.Builder.m_20704_(SeatEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SeatEntity::new).m_20719_().m_20699_(0.05f, 0.35f));
    public static final RegistryObject<EntityType<SCP131Entity>> SCP_131 = ScpContainedModEntities.register("scp_131", EntityType.Builder.m_20704_(SCP131Entity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SCP131Entity::new).m_20719_().m_20699_(0.75f, 1.0f));
    public static final RegistryObject<EntityType<SCP131BEntity>> SCP_131_B = ScpContainedModEntities.register("scp_131_b", EntityType.Builder.m_20704_(SCP131BEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(SCP131BEntity::new).m_20719_().m_20699_(0.75f, 1.0f));
    public static final RegistryObject<EntityType<TestEntityEntity>> TEST_ENTITY = ScpContainedModEntities.register("test_entity", EntityType.Builder.m_20704_(TestEntityEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(10000).setUpdateInterval(3).setCustomClientFactory(TestEntityEntity::new).m_20719_().m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<SCP457Entity>> SCP_457 = ScpContainedModEntities.register("scp_457", EntityType.Builder.m_20704_(SCP457Entity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(SCP457Entity::new).m_20699_(0.9f, 1.8f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SeatEntity.init();
            SCP131Entity.init();
            SCP131BEntity.init();
            TestEntityEntity.init();
            SCP457Entity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SEAT.get(), SeatEntity.createAttributes().m_22265_());
        event.put((EntityType)SCP_131.get(), SCP131Entity.createAttributes().m_22265_());
        event.put((EntityType)SCP_131_B.get(), SCP131BEntity.createAttributes().m_22265_());
        event.put((EntityType)TEST_ENTITY.get(), TestEntityEntity.createAttributes().m_22265_());
        event.put((EntityType)SCP_457.get(), SCP457Entity.createAttributes().m_22265_());
    }
}

