/*
 * Decompiled with CFR 0.152.
 */
package net.robin.scpc.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.robin.scpc.ScpContainedMod;
import net.robin.scpc.procedures.AllAnnounceProcedure;
import net.robin.scpc.procedures.AttAnnounceProcedure;
import net.robin.scpc.procedures.AttPleaseAnnounceProcedure;
import net.robin.scpc.procedures.BreachAnnounceProcedure;
import net.robin.scpc.procedures.CivilianAnnounceProcedure;
import net.robin.scpc.procedures.CombatAnnounceProcedure;
import net.robin.scpc.procedures.EvacuateAnnounceProcedure;
import net.robin.scpc.procedures.ManageRiotAnnounceProcedure;
import net.robin.scpc.procedures.OpenControlProcedure;
import net.robin.scpc.procedures.RecontainAnnounceProcedure;
import net.robin.scpc.procedures.RiotAnnounceProcedure;
import net.robin.scpc.procedures.ScientificAnnounceProcedure;
import net.robin.scpc.world.inventory.SCPANNOUNCEMENTTERMINALMenu;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class SCPANNOUNCEMENTTERMINALButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public SCPANNOUNCEMENTTERMINALButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public SCPANNOUNCEMENTTERMINALButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(SCPANNOUNCEMENTTERMINALButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(SCPANNOUNCEMENTTERMINALButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            SCPANNOUNCEMENTTERMINALButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = SCPANNOUNCEMENTTERMINALMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            BreachAnnounceProcedure.execute((LevelAccessor)world, x, y, z, guistate);
        }
        if (buttonID == 1) {
            RiotAnnounceProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            AttAnnounceProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            AttPleaseAnnounceProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            CombatAnnounceProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            ScientificAnnounceProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 6) {
            CivilianAnnounceProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 7) {
            AllAnnounceProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 8) {
            ManageRiotAnnounceProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 9) {
            RecontainAnnounceProcedure.execute((LevelAccessor)world, x, y, z, guistate);
        }
        if (buttonID == 10) {
            EvacuateAnnounceProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 12) {
            OpenControlProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ScpContainedMod.addNetworkMessage(SCPANNOUNCEMENTTERMINALButtonMessage.class, SCPANNOUNCEMENTTERMINALButtonMessage::buffer, SCPANNOUNCEMENTTERMINALButtonMessage::new, SCPANNOUNCEMENTTERMINALButtonMessage::handler);
    }
}

