/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astratemplate.org.jetbrains.exposed.sql;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.astratemplate.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astratemplate.org.jetbrains.annotations.Nullable;
import ru.astrainteractive.astratemplate.org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import ru.astrainteractive.astratemplate.org.jetbrains.exposed.sql.SchemaKt;
import ru.astrainteractive.astratemplate.org.jetbrains.exposed.sql.transactions.TransactionManager;
import ru.astrainteractive.astratemplate.org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010 \n\u0002\b\u0006\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u001c\u001a\u00020\u0003H\u0016J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u001eJ\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030\u001eJ\u0006\u0010#\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0013\u0010\u0011R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0014\u0010\u0011R\u0015\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0015\u0010\u0011R\u0015\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0019\u0010\u0011R\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000fR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006$"}, d2={"Lru/astrainteractive/astratemplate/org/jetbrains/exposed/sql/Sequence;", "", "name", "", "startWith", "", "incrementBy", "minValue", "maxValue", "cycle", "", "cache", "<init>", "(Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Boolean;Ljava/lang/Long;)V", "getName", "()Ljava/lang/String;", "getStartWith", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getIncrementBy", "getMinValue", "getMaxValue", "getCycle", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getCache", "identifier", "getIdentifier", "toString", "ddl", "", "getDdl", "()Ljava/util/List;", "createStatement", "dropStatement", "exists", "exposed-core"})
public final class Sequence {
    @NotNull
    private final String name;
    @Nullable
    private final Long startWith;
    @Nullable
    private final Long incrementBy;
    @Nullable
    private final Long minValue;
    @Nullable
    private final Long maxValue;
    @Nullable
    private final Boolean cycle;
    @Nullable
    private final Long cache;

    public Sequence(@NotNull String name, @Nullable Long startWith, @Nullable Long incrementBy, @Nullable Long minValue, @Nullable Long maxValue, @Nullable Boolean cycle, @Nullable Long cache2) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.name = name;
        this.startWith = startWith;
        this.incrementBy = incrementBy;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.cycle = cycle;
        this.cache = cache2;
    }

    public /* synthetic */ Sequence(String string, Long l, Long l2, Long l3, Long l4, Boolean bl, Long l5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = null;
        }
        if ((n & 4) != 0) {
            l2 = null;
        }
        if ((n & 8) != 0) {
            l3 = null;
        }
        if ((n & 0x10) != 0) {
            l4 = null;
        }
        if ((n & 0x20) != 0) {
            bl = null;
        }
        if ((n & 0x40) != 0) {
            l5 = null;
        }
        this(string, l, l2, l3, l4, bl, l5);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final Long getStartWith() {
        return this.startWith;
    }

    @Nullable
    public final Long getIncrementBy() {
        return this.incrementBy;
    }

    @Nullable
    public final Long getMinValue() {
        return this.minValue;
    }

    @Nullable
    public final Long getMaxValue() {
        return this.maxValue;
    }

    @Nullable
    public final Boolean getCycle() {
        return this.cycle;
    }

    @Nullable
    public final Long getCache() {
        return this.cache;
    }

    @NotNull
    public final String getIdentifier() {
        return TransactionManager.Companion.current().getDb().getIdentifierManager().cutIfNecessaryAndQuote(this.name);
    }

    @NotNull
    public String toString() {
        return "Sequence(identifier=" + this.getIdentifier() + ')';
    }

    @NotNull
    public final List<String> getDdl() {
        return this.createStatement();
    }

    @NotNull
    public final List<String> createStatement() {
        StringBuilder stringBuilder;
        if (!DatabaseDialectKt.getCurrentDialect().getSupportsCreateSequence()) {
            throw new UnsupportedByDialectException("The current dialect doesn't support create sequence statement", DatabaseDialectKt.getCurrentDialect());
        }
        StringBuilder $this$createStatement_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$createStatement_u24lambda_u240.append("CREATE SEQUENCE ");
        if (DatabaseDialectKt.getCurrentDialect().getSupportsIfNotExists()) {
            $this$createStatement_u24lambda_u240.append("IF NOT EXISTS ");
        }
        $this$createStatement_u24lambda_u240.append(this.getIdentifier());
        SchemaKt.appendIfNotNull($this$createStatement_u24lambda_u240, " START WITH", this.startWith);
        SchemaKt.appendIfNotNull($this$createStatement_u24lambda_u240, " INCREMENT BY", this.incrementBy);
        SchemaKt.appendIfNotNull($this$createStatement_u24lambda_u240, " MINVALUE", this.minValue);
        SchemaKt.appendIfNotNull($this$createStatement_u24lambda_u240, " MAXVALUE", this.maxValue);
        if (Intrinsics.areEqual(this.cycle, true)) {
            $this$createStatement_u24lambda_u240.append(" CYCLE");
        }
        SchemaKt.appendIfNotNull($this$createStatement_u24lambda_u240, " CACHE", this.cache);
        String createSequenceDDL = stringBuilder.toString();
        return CollectionsKt.listOf(createSequenceDDL);
    }

    @NotNull
    public final List<String> dropStatement() {
        StringBuilder stringBuilder;
        if (!DatabaseDialectKt.getCurrentDialect().getSupportsCreateSequence()) {
            throw new UnsupportedByDialectException("The current dialect doesn't support drop sequence statement", DatabaseDialectKt.getCurrentDialect());
        }
        StringBuilder $this$dropStatement_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$dropStatement_u24lambda_u241.append("DROP SEQUENCE ");
        if (DatabaseDialectKt.getCurrentDialect().getSupportsIfNotExists()) {
            $this$dropStatement_u24lambda_u241.append("IF EXISTS ");
        }
        $this$dropStatement_u24lambda_u241.append(this.getIdentifier());
        String dropSequenceDDL = stringBuilder.toString();
        return CollectionsKt.listOf(dropSequenceDDL);
    }

    public final boolean exists() {
        return DatabaseDialectKt.getCurrentDialect().sequenceExists(this);
    }
}

