/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astratemplate.org.jetbrains.exposed.sql.vendors;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.astratemplate.org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astratemplate.org.jetbrains.exposed.sql.vendors.DataTypeProvider;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016\u00a8\u0006\u0011"}, d2={"Lru/astrainteractive/astratemplate/org/jetbrains/exposed/sql/vendors/H2DataTypeProvider;", "Lru/astrainteractive/astratemplate/org/jetbrains/exposed/sql/vendors/DataTypeProvider;", "<init>", "()V", "binaryType", "", "uuidType", "uuidToDB", "", "value", "Ljava/util/UUID;", "dateTimeType", "timestampType", "timestampWithTimeZoneType", "jsonBType", "hexToDb", "hexString", "exposed-core"})
public final class H2DataTypeProvider
extends DataTypeProvider {
    @NotNull
    public static final H2DataTypeProvider INSTANCE = new H2DataTypeProvider();

    private H2DataTypeProvider() {
    }

    @Override
    @NotNull
    public String binaryType() {
        return "VARBINARY";
    }

    @Override
    @NotNull
    public String uuidType() {
        return "UUID";
    }

    @Override
    @NotNull
    public Object uuidToDB(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter(value, "value");
        String string = value.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Override
    @NotNull
    public String dateTimeType() {
        return "DATETIME(9)";
    }

    @Override
    @NotNull
    public String timestampType() {
        return "TIMESTAMP(9)";
    }

    @Override
    @NotNull
    public String timestampWithTimeZoneType() {
        return "TIMESTAMP(9) WITH TIME ZONE";
    }

    @Override
    @NotNull
    public String jsonBType() {
        return "JSON";
    }

    @Override
    @NotNull
    public String hexToDb(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter(hexString, "hexString");
        return "X'" + hexString + '\'';
    }
}

