/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.astrainteractive.astratemplate.shade.kotlin.collections.CollectionsKt;
import ru.astrainteractive.astratemplate.shade.kotlin.collections.SetsKt;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.functions.Function1;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.name.FqName;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.name.Name;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindExclude;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScopeImpl;

public class SubpackagesScope
extends MemberScopeImpl {
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final FqName fqName;

    public SubpackagesScope(@NotNull ModuleDescriptor moduleDescriptor, @NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(fqName, "fqName");
        this.moduleDescriptor = moduleDescriptor;
        this.fqName = fqName;
    }

    @Nullable
    protected final PackageViewDescriptor getPackage(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        if (name2.isSpecial()) {
            return null;
        }
        FqName fqName = this.fqName.child(name2);
        Intrinsics.checkNotNullExpressionValue(fqName, "child(...)");
        PackageViewDescriptor packageViewDescriptor = this.moduleDescriptor.getPackage(fqName);
        if (packageViewDescriptor.isEmpty()) {
            return null;
        }
        return packageViewDescriptor;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkNotNullParameter(kindFilter, "kindFilter");
        Intrinsics.checkNotNullParameter(nameFilter, "nameFilter");
        if (!kindFilter.acceptsKinds(DescriptorKindFilter.Companion.getPACKAGES_MASK())) {
            return CollectionsKt.emptyList();
        }
        if (this.fqName.isRoot() && kindFilter.getExcludes().contains(DescriptorKindExclude.TopLevelPackages.INSTANCE)) {
            return CollectionsKt.emptyList();
        }
        Collection<FqName> subFqNames = this.moduleDescriptor.getSubPackagesOf(this.fqName, nameFilter);
        ArrayList result = new ArrayList(subFqNames.size());
        for (FqName subFqName : subFqNames) {
            Name shortName;
            Intrinsics.checkNotNullExpressionValue(subFqName.shortName(), "shortName(...)");
            if (!nameFilter.invoke(shortName).booleanValue()) continue;
            ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.addIfNotNull(result, this.getPackage(shortName));
        }
        return result;
    }

    @Override
    @NotNull
    public Set<Name> getClassifierNames() {
        return SetsKt.emptySet();
    }

    @NotNull
    public String toString() {
        return "subpackages of " + this.fqName + " from " + this.moduleDescriptor;
    }
}

