/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectJavaClassFinderKt;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaPackage;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.load.java.JavaClassFinder;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.load.java.structure.JavaPackage;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.name.ClassId;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.name.FqName;
import ru.astrainteractive.astratemplate.shade.kotlin.text.StringsKt;

public final class ReflectJavaClassFinder
implements JavaClassFinder {
    @NotNull
    private final ClassLoader classLoader;

    public ReflectJavaClassFinder(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter(classLoader, "classLoader");
        this.classLoader = classLoader;
    }

    @Override
    @Nullable
    public JavaClass findClass(@NotNull JavaClassFinder.Request request) {
        Intrinsics.checkNotNullParameter(request, "request");
        ClassId classId = request.getClassId();
        FqName packageFqName = classId.getPackageFqName();
        String string = classId.getRelativeClassName().asString();
        Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
        String relativeClassName = StringsKt.replace$default(string, '.', '$', false, 4, null);
        String name2 = packageFqName.isRoot() ? relativeClassName : packageFqName.asString() + '.' + relativeClassName;
        Class<?> klass = ReflectJavaClassFinderKt.tryLoadClass(this.classLoader, name2);
        return klass != null ? (JavaClass)new ReflectJavaClass(klass) : null;
    }

    @Override
    @Nullable
    public JavaPackage findPackage(@NotNull FqName fqName, boolean mayHaveAnnotations) {
        Intrinsics.checkNotNullParameter(fqName, "fqName");
        return new ReflectJavaPackage(fqName);
    }

    @Override
    @Nullable
    public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        return null;
    }
}

