/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.load.kotlin;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.astrainteractive.astratemplate.shade.kotlin._Assertions;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializedDescriptorResolver;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinderKt;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.name.ClassId;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassData;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.utils.DeserializationHelpersKt;

public final class JavaClassDataFinder
implements ClassDataFinder {
    @NotNull
    private final KotlinClassFinder kotlinClassFinder;
    @NotNull
    private final DeserializedDescriptorResolver deserializedDescriptorResolver;

    public JavaClassDataFinder(@NotNull KotlinClassFinder kotlinClassFinder, @NotNull DeserializedDescriptorResolver deserializedDescriptorResolver) {
        Intrinsics.checkNotNullParameter(kotlinClassFinder, "ru.astrainteractive.astratemplate.shade.kotlinClassFinder");
        Intrinsics.checkNotNullParameter(deserializedDescriptorResolver, "deserializedDescriptorResolver");
        this.kotlinClassFinder = kotlinClassFinder;
        this.deserializedDescriptorResolver = deserializedDescriptorResolver;
    }

    @Override
    @Nullable
    public ClassData findClassData(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = KotlinClassFinderKt.findKotlinClass(this.kotlinClassFinder, classId, DeserializationHelpersKt.jvmMetadataVersionOrDefault(this.deserializedDescriptorResolver.getComponents().getConfiguration()));
        if (kotlinJvmBinaryClass == null) {
            return null;
        }
        KotlinJvmBinaryClass kotlinClass = kotlinJvmBinaryClass;
        boolean bl = Intrinsics.areEqual(kotlinClass.getClassId(), classId);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Class with incorrect id found: expected " + classId + ", actual " + kotlinClass.getClassId();
            throw new AssertionError((Object)string);
        }
        return this.deserializedDescriptorResolver.readClassData$descriptors_jvm(kotlinClass);
    }
}

