/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.load.kotlin;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.name.Name;
import ru.astrainteractive.astratemplate.shade.kotlin.text.StringsKt;

public class JvmDescriptorTypeWriter<T> {
    @NotNull
    private final JvmTypeFactory<T> jvmTypeFactory;
    private int jvmCurrentTypeArrayLevel;
    @Nullable
    private T jvmCurrentType;

    public void writeArrayType() {
        if (this.jvmCurrentType == null) {
            ++this.jvmCurrentTypeArrayLevel;
        }
    }

    public void writeArrayEnd() {
    }

    public void writeClass(@NotNull T objectType) {
        Intrinsics.checkNotNullParameter(objectType, "objectType");
        this.writeJvmTypeAsIs(objectType);
    }

    protected final void writeJvmTypeAsIs(@NotNull T type) {
        Intrinsics.checkNotNullParameter(type, "type");
        if (this.jvmCurrentType == null) {
            this.jvmCurrentType = this.jvmCurrentTypeArrayLevel > 0 ? this.jvmTypeFactory.createFromString(StringsKt.repeat("[", this.jvmCurrentTypeArrayLevel) + this.jvmTypeFactory.toString(type)) : type;
        }
    }

    public void writeTypeVariable(@NotNull Name name2, @NotNull T type) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(type, "type");
        this.writeJvmTypeAsIs(type);
    }
}

