/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types;

import org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.model.FlexibleTypeMarker;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.model.SimpleTypeMarker;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.model.TypeArgumentMarker;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.model.TypeSystemContext;

public final class AbstractStrictEqualityTypeChecker {
    @NotNull
    public static final AbstractStrictEqualityTypeChecker INSTANCE = new AbstractStrictEqualityTypeChecker();

    private AbstractStrictEqualityTypeChecker() {
    }

    public final boolean strictEqualTypes(@NotNull TypeSystemContext context, @NotNull KotlinTypeMarker a, @NotNull KotlinTypeMarker b) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return this.strictEqualTypesInternal(context, a, b);
    }

    private final boolean strictEqualTypesInternal(TypeSystemContext $this$strictEqualTypesInternal, KotlinTypeMarker a, KotlinTypeMarker b) {
        if (a == b) {
            return true;
        }
        SimpleTypeMarker simpleA = $this$strictEqualTypesInternal.asSimpleType(a);
        SimpleTypeMarker simpleB = $this$strictEqualTypesInternal.asSimpleType(b);
        if (simpleA != null && simpleB != null) {
            return this.strictEqualSimpleTypes($this$strictEqualTypesInternal, simpleA, simpleB);
        }
        FlexibleTypeMarker flexibleA = $this$strictEqualTypesInternal.asFlexibleType(a);
        FlexibleTypeMarker flexibleB = $this$strictEqualTypesInternal.asFlexibleType(b);
        if (flexibleA != null && flexibleB != null) {
            return this.strictEqualSimpleTypes($this$strictEqualTypesInternal, $this$strictEqualTypesInternal.lowerBound(flexibleA), $this$strictEqualTypesInternal.lowerBound(flexibleB)) && this.strictEqualSimpleTypes($this$strictEqualTypesInternal, $this$strictEqualTypesInternal.upperBound(flexibleA), $this$strictEqualTypesInternal.upperBound(flexibleB));
        }
        return false;
    }

    private final boolean strictEqualSimpleTypes(TypeSystemContext $this$strictEqualSimpleTypes, SimpleTypeMarker a, SimpleTypeMarker b) {
        if ($this$strictEqualSimpleTypes.argumentsCount(a) != $this$strictEqualSimpleTypes.argumentsCount(b) || $this$strictEqualSimpleTypes.isMarkedNullable(a) != $this$strictEqualSimpleTypes.isMarkedNullable(b) || $this$strictEqualSimpleTypes.asDefinitelyNotNullType(a) == null != ($this$strictEqualSimpleTypes.asDefinitelyNotNullType(b) == null) || !$this$strictEqualSimpleTypes.areEqualTypeConstructors($this$strictEqualSimpleTypes.typeConstructor(a), $this$strictEqualSimpleTypes.typeConstructor(b))) {
            return false;
        }
        if ($this$strictEqualSimpleTypes.identicalArguments(a, b)) {
            return true;
        }
        int n = $this$strictEqualSimpleTypes.argumentsCount(a);
        for (int i = 0; i < n; ++i) {
            TypeArgumentMarker aArg = $this$strictEqualSimpleTypes.getArgument(a, i);
            TypeArgumentMarker bArg = $this$strictEqualSimpleTypes.getArgument(b, i);
            if ($this$strictEqualSimpleTypes.isStarProjection(aArg) != $this$strictEqualSimpleTypes.isStarProjection(bArg)) {
                return false;
            }
            if ($this$strictEqualSimpleTypes.isStarProjection(aArg)) continue;
            if ($this$strictEqualSimpleTypes.getVariance(aArg) != $this$strictEqualSimpleTypes.getVariance(bArg)) {
                return false;
            }
            if (this.strictEqualTypesInternal($this$strictEqualSimpleTypes, $this$strictEqualSimpleTypes.getType(aArg), $this$strictEqualSimpleTypes.getType(bArg))) continue;
            return false;
        }
        return true;
    }
}

