/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.error;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astratemplate.shade.kotlin.collections.CollectionsKt;
import ru.astrainteractive.astratemplate.shade.kotlin.collections.SetsKt;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.functions.Function1;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.name.Name;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.error.ErrorClassDescriptor;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.error.ErrorEntity;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.error.ErrorFunctionDescriptor;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.error.ErrorScopeKind;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

public class ErrorScope
implements MemberScope {
    @NotNull
    private final ErrorScopeKind kind;
    @NotNull
    private final String debugMessage;

    public ErrorScope(@NotNull ErrorScopeKind kind, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        this.kind = kind;
        String[] stringArray = Arrays.copyOf(formatParams, formatParams.length);
        String string = String.format(this.kind.getDebugMessage(), Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        this.debugMessage = string;
    }

    @NotNull
    protected final String getDebugMessage() {
        return this.debugMessage;
    }

    @Override
    @NotNull
    public ClassifierDescriptor getContributedClassifier(@NotNull Name name2, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        String string = ErrorEntity.ERROR_CLASS.getDebugText();
        Object[] objectArray = new Object[]{name2};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        Name name3 = Name.special(string2);
        Intrinsics.checkNotNullExpressionValue(name3, "special(...)");
        return new ErrorClassDescriptor(name3);
    }

    @NotNull
    public Set<PropertyDescriptor> getContributedVariables(@NotNull Name name2, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        return ErrorUtils.INSTANCE.getErrorPropertyGroup();
    }

    @NotNull
    public Set<SimpleFunctionDescriptor> getContributedFunctions(@NotNull Name name2, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        return SetsKt.setOf(new ErrorFunctionDescriptor(ErrorUtils.INSTANCE.getErrorClass()));
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter) {
        Intrinsics.checkNotNullParameter(kindFilter, "kindFilter");
        Intrinsics.checkNotNullParameter(nameFilter, "nameFilter");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Set<Name> getFunctionNames() {
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Set<Name> getVariableNames() {
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Set<Name> getClassifierNames() {
        return SetsKt.emptySet();
    }

    @Override
    public void recordLookup(@NotNull Name name2, @NotNull LookupLocation location) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(location, "location");
    }

    @NotNull
    public String toString() {
        return "ErrorScope{" + this.debugMessage + '}';
    }
}

