/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.error;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.astrainteractive.astratemplate.shade.kotlin._Assertions;
import ru.astrainteractive.astratemplate.shade.kotlin.collections.CollectionsKt;
import ru.astrainteractive.astratemplate.shade.kotlin.collections.SetsKt;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.JvmStatic;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.name.Name;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.KotlinType;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.error.ErrorClassDescriptor;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.error.ErrorEntity;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.error.ErrorModuleDescriptor;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.error.ErrorPropertyDescriptor;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.error.ErrorScope;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.error.ErrorScopeKind;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeConstructor;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.error.ThrowingScope;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class ErrorUtils {
    @NotNull
    public static final ErrorUtils INSTANCE = new ErrorUtils();
    @NotNull
    private static final ModuleDescriptor errorModule = ErrorModuleDescriptor.INSTANCE;
    @NotNull
    private static final ErrorClassDescriptor errorClass;
    @NotNull
    private static final KotlinType errorTypeForLoopInSupertypes;
    @NotNull
    private static final KotlinType errorPropertyType;
    @NotNull
    private static final PropertyDescriptor errorProperty;
    @NotNull
    private static final Set<PropertyDescriptor> errorPropertyGroup;

    private ErrorUtils() {
    }

    @NotNull
    public final ModuleDescriptor getErrorModule() {
        return errorModule;
    }

    @NotNull
    public final ErrorClassDescriptor getErrorClass() {
        return errorClass;
    }

    @NotNull
    public final KotlinType getErrorTypeForLoopInSupertypes() {
        return errorTypeForLoopInSupertypes;
    }

    @NotNull
    public final KotlinType getErrorPropertyType() {
        return errorPropertyType;
    }

    @NotNull
    public final Set<PropertyDescriptor> getErrorPropertyGroup() {
        return errorPropertyGroup;
    }

    @JvmStatic
    @NotNull
    public static final ErrorScope createErrorScope(@NotNull ErrorScopeKind kind, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        return ErrorUtils.createErrorScope(kind, false, Arrays.copyOf(formatParams, formatParams.length));
    }

    @JvmStatic
    @NotNull
    public static final ErrorScope createErrorScope(@NotNull ErrorScopeKind kind, boolean throwExceptions, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        return throwExceptions ? (ErrorScope)new ThrowingScope(kind, Arrays.copyOf(formatParams, formatParams.length)) : new ErrorScope(kind, Arrays.copyOf(formatParams, formatParams.length));
    }

    @JvmStatic
    @NotNull
    public static final ErrorType createErrorType(@NotNull ErrorTypeKind kind, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        return INSTANCE.createErrorTypeWithArguments(kind, CollectionsKt.emptyList(), Arrays.copyOf(formatParams, formatParams.length));
    }

    @NotNull
    public final ErrorType createErrorType(@NotNull ErrorTypeKind kind, @NotNull TypeConstructor typeConstructor2, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(typeConstructor2, "typeConstructor");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        return this.createErrorTypeWithArguments(kind, CollectionsKt.emptyList(), typeConstructor2, Arrays.copyOf(formatParams, formatParams.length));
    }

    @NotNull
    public final ErrorType createErrorTypeWithArguments(@NotNull ErrorTypeKind kind, @NotNull List<? extends TypeProjection> arguments2, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        return this.createErrorTypeWithArguments(kind, arguments2, this.createErrorTypeConstructor(kind, Arrays.copyOf(formatParams, formatParams.length)), Arrays.copyOf(formatParams, formatParams.length));
    }

    @NotNull
    public final ErrorType createErrorTypeWithArguments(@NotNull ErrorTypeKind kind, @NotNull List<? extends TypeProjection> arguments2, @NotNull TypeConstructor typeConstructor2, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(typeConstructor2, "typeConstructor");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        String[] stringArray = new String[]{typeConstructor2.toString()};
        return new ErrorType(typeConstructor2, (MemberScope)ErrorUtils.createErrorScope(ErrorScopeKind.ERROR_TYPE_SCOPE, stringArray), kind, arguments2, false, Arrays.copyOf(formatParams, formatParams.length));
    }

    @NotNull
    public final ErrorTypeConstructor createErrorTypeConstructor(@NotNull ErrorTypeKind kind, String ... formatParams) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(formatParams, "formatParams");
        return new ErrorTypeConstructor(kind, Arrays.copyOf(formatParams, formatParams.length));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isError(@Nullable DeclarationDescriptor candidate2) {
        if (candidate2 == null) return false;
        if (INSTANCE.isErrorClass(candidate2)) return true;
        if (INSTANCE.isErrorClass(candidate2.getContainingDeclaration())) return true;
        if (candidate2 != errorModule) return false;
        return true;
    }

    private final boolean isErrorClass(DeclarationDescriptor candidate2) {
        return candidate2 instanceof ErrorClassDescriptor;
    }

    @JvmStatic
    public static final boolean isUninferredTypeVariable(@Nullable KotlinType type) {
        if (type == null) {
            return false;
        }
        TypeConstructor constructor = type.getConstructor();
        return constructor instanceof ErrorTypeConstructor && ((ErrorTypeConstructor)constructor).getKind() == ErrorTypeKind.UNINFERRED_TYPE_VARIABLE;
    }

    @NotNull
    public final String unresolvedTypeAsItIs(@NotNull KotlinType type) {
        Intrinsics.checkNotNullParameter(type, "type");
        boolean bl = TypeUtilsKt.isUnresolvedType(type);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        TypeConstructor typeConstructor2 = type.getConstructor();
        Intrinsics.checkNotNull(typeConstructor2, "null cannot be cast to non-null type org.jetbrains.kotlin.types.error.ErrorTypeConstructor");
        return ((ErrorTypeConstructor)typeConstructor2).getParam(0);
    }

    static {
        String string = ErrorEntity.ERROR_CLASS.getDebugText();
        Object[] objectArray = new Object[]{"unknown class"};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        Name name2 = Name.special(string2);
        Intrinsics.checkNotNullExpressionValue(name2, "special(...)");
        errorClass = new ErrorClassDescriptor(name2);
        errorTypeForLoopInSupertypes = ErrorUtils.createErrorType(ErrorTypeKind.CYCLIC_SUPERTYPES, new String[0]);
        errorPropertyType = ErrorUtils.createErrorType(ErrorTypeKind.ERROR_PROPERTY_TYPE, new String[0]);
        errorProperty = new ErrorPropertyDescriptor();
        errorPropertyGroup = SetsKt.setOf(errorProperty);
    }
}

