/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.builtins.ReflectionTypes;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.KotlinType;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import ru.astrainteractive.astratemplate.shade.kotlin.reflect.jvm.internal.impl.util.Check;

final class IsKPropertyCheck
implements Check {
    @NotNull
    public static final IsKPropertyCheck INSTANCE = new IsKPropertyCheck();
    @NotNull
    private static final String description = "second parameter must be of type KProperty<*> or its supertype";

    private IsKPropertyCheck() {
    }

    @Override
    @NotNull
    public String getDescription() {
        return description;
    }

    @Override
    public boolean check(@NotNull FunctionDescriptor functionDescriptor) {
        boolean bl;
        Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
        ValueParameterDescriptor secondParameter = functionDescriptor.getValueParameters().get(1);
        Intrinsics.checkNotNull(secondParameter);
        KotlinType kotlinType = ReflectionTypes.Companion.createKPropertyStarType(DescriptorUtilsKt.getModule(secondParameter));
        if (kotlinType != null) {
            KotlinType kotlinType2 = secondParameter.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
            bl = TypeUtilsKt.isSubtypeOf(kotlinType, TypeUtilsKt.makeNotNullable(kotlinType2));
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @Nullable
    public String invoke(@NotNull FunctionDescriptor functionDescriptor) {
        return Check.DefaultImpls.invoke(this, functionDescriptor);
    }
}

