/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astratemplate.shade.okio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.astrainteractive.astratemplate.shade.kotlin.Metadata;
import ru.astrainteractive.astratemplate.shade.kotlin.collections.CollectionsKt;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.SourceDebugExtension;
import ru.astrainteractive.astratemplate.shade.okio.FileHandle;
import ru.astrainteractive.astratemplate.shade.okio.FileMetadata;
import ru.astrainteractive.astratemplate.shade.okio.FileSystem;
import ru.astrainteractive.astratemplate.shade.okio.JvmFileHandle;
import ru.astrainteractive.astratemplate.shade.okio.Okio;
import ru.astrainteractive.astratemplate.shade.okio.Path;
import ru.astrainteractive.astratemplate.shade.okio.Sink;
import ru.astrainteractive.astratemplate.shade.okio.Source;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0018\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J \u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J \u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0005H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\b\u0010 \u001a\u00020!H\u0016J\f\u0010\"\u001a\u00020\u001b*\u00020\u0005H\u0002J\f\u0010#\u001a\u00020\u001b*\u00020\u0005H\u0002\u00a8\u0006$"}, d2={"Lru/astrainteractive/astratemplate/shade/okio/JvmSystemFileSystem;", "Lru/astrainteractive/astratemplate/shade/okio/FileSystem;", "<init>", "()V", "canonicalize", "Lru/astrainteractive/astratemplate/shade/okio/Path;", "path", "metadataOrNull", "Lru/astrainteractive/astratemplate/shade/okio/FileMetadata;", "list", "", "dir", "listOrNull", "throwOnFailure", "", "openReadOnly", "Lru/astrainteractive/astratemplate/shade/okio/FileHandle;", "file", "openReadWrite", "mustCreate", "mustExist", "source", "Lru/astrainteractive/astratemplate/shade/okio/Source;", "sink", "Lru/astrainteractive/astratemplate/shade/okio/Sink;", "appendingSink", "createDirectory", "", "atomicMove", "target", "delete", "createSymlink", "toString", "", "requireExist", "requireCreate", "ru.astrainteractive.astratemplate.shade.okio"})
@SourceDebugExtension(value={"SMAP\nJvmSystemFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmSystemFileSystem.kt\nokio/JvmSystemFileSystem\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,158:1\n11563#2,3:159\n*S KotlinDebug\n*F\n+ 1 JvmSystemFileSystem.kt\nokio/JvmSystemFileSystem\n*L\n77#1:159,3\n*E\n"})
public class JvmSystemFileSystem
extends FileSystem {
    @Override
    @NotNull
    public Path canonicalize(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        File canonicalFile = path.toFile().getCanonicalFile();
        if (!canonicalFile.exists()) {
            throw new FileNotFoundException("no such file");
        }
        Intrinsics.checkNotNull(canonicalFile);
        return Path.Companion.get$default(Path.Companion, canonicalFile, false, 1, null);
    }

    @Override
    @Nullable
    public FileMetadata metadataOrNull(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        File file = path.toFile();
        boolean isRegularFile = file.isFile();
        boolean isDirectory = file.isDirectory();
        long lastModifiedAtMillis = file.lastModified();
        long size = file.length();
        if (!(isRegularFile || isDirectory || lastModifiedAtMillis != 0L || size != 0L || file.exists())) {
            return null;
        }
        return new FileMetadata(isRegularFile, isDirectory, null, size, null, lastModifiedAtMillis, null, null, 128, null);
    }

    @Override
    @NotNull
    public List<Path> list(@NotNull Path dir2) {
        Intrinsics.checkNotNullParameter(dir2, "dir");
        List<Path> list = this.list(dir2, true);
        Intrinsics.checkNotNull(list);
        return list;
    }

    @Override
    @Nullable
    public List<Path> listOrNull(@NotNull Path dir2) {
        Intrinsics.checkNotNullParameter(dir2, "dir");
        return this.list(dir2, false);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> list(Path dir2, boolean throwOnFailure) {
        void destination$iv;
        void $this$mapTo$iv;
        File file = dir2.toFile();
        String[] entries = file.list();
        if (entries == null) {
            if (throwOnFailure) {
                if (!file.exists()) {
                    throw new FileNotFoundException("no such file: " + dir2);
                }
                throw new IOException("failed to list " + dir2);
            }
            return null;
        }
        String[] stringArray = entries;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv;
            void var12_11 = item$iv = $this$mapTo$iv[i];
            void var14_13 = destination$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            var14_13.add(dir2.resolve((String)it));
        }
        List result = (List)destination$iv;
        CollectionsKt.sort(result);
        return result;
    }

    @Override
    @NotNull
    public FileHandle openReadOnly(@NotNull Path file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return new JvmFileHandle(false, new RandomAccessFile(file.toFile(), "r"));
    }

    @Override
    @NotNull
    public FileHandle openReadWrite(@NotNull Path file, boolean mustCreate, boolean mustExist) {
        Intrinsics.checkNotNullParameter(file, "file");
        if (!(!mustCreate || !mustExist)) {
            boolean bl = false;
            String string = "Cannot require mustCreate and mustExist at the same time.";
            throw new IllegalArgumentException(string.toString());
        }
        if (mustCreate) {
            this.requireCreate(file);
        }
        if (mustExist) {
            this.requireExist(file);
        }
        return new JvmFileHandle(true, new RandomAccessFile(file.toFile(), "rw"));
    }

    @Override
    @NotNull
    public Source source(@NotNull Path file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return Okio.source(file.toFile());
    }

    @Override
    @NotNull
    public Sink sink(@NotNull Path file, boolean mustCreate) {
        Intrinsics.checkNotNullParameter(file, "file");
        if (mustCreate) {
            this.requireCreate(file);
        }
        return Okio.sink$default(file.toFile(), false, 1, null);
    }

    @Override
    @NotNull
    public Sink appendingSink(@NotNull Path file, boolean mustExist) {
        Intrinsics.checkNotNullParameter(file, "file");
        if (mustExist) {
            this.requireExist(file);
        }
        return Okio.sink(file.toFile(), true);
    }

    @Override
    public void createDirectory(@NotNull Path dir2, boolean mustCreate) {
        Intrinsics.checkNotNullParameter(dir2, "dir");
        if (!dir2.toFile().mkdir()) {
            boolean alreadyExist;
            FileMetadata fileMetadata = this.metadataOrNull(dir2);
            boolean bl = fileMetadata != null ? fileMetadata.isDirectory() : (alreadyExist = false);
            if (alreadyExist) {
                if (mustCreate) {
                    throw new IOException(dir2 + " already exists.");
                }
                return;
            }
            throw new IOException("failed to create directory: " + dir2);
        }
    }

    @Override
    public void atomicMove(@NotNull Path source2, @NotNull Path target) {
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(target, "target");
        boolean renamed = source2.toFile().renameTo(target.toFile());
        if (!renamed) {
            throw new IOException("failed to move " + source2 + " to " + target);
        }
    }

    @Override
    public void delete(@NotNull Path path, boolean mustExist) {
        Intrinsics.checkNotNullParameter(path, "path");
        if (Thread.interrupted()) {
            throw new InterruptedIOException("interrupted");
        }
        File file = path.toFile();
        boolean deleted = file.delete();
        if (!deleted) {
            if (file.exists()) {
                throw new IOException("failed to delete " + path);
            }
            if (mustExist) {
                throw new FileNotFoundException("no such file: " + path);
            }
        }
    }

    @Override
    public void createSymlink(@NotNull Path source2, @NotNull Path target) {
        Intrinsics.checkNotNullParameter(source2, "source");
        Intrinsics.checkNotNullParameter(target, "target");
        throw new IOException("unsupported");
    }

    @NotNull
    public String toString() {
        return "JvmSystemFileSystem";
    }

    private final void requireExist(Path $this$requireExist) {
        if (!this.exists($this$requireExist)) {
            throw new IOException($this$requireExist + " doesn't exist.");
        }
    }

    private final void requireCreate(Path $this$requireCreate) {
        if (this.exists($this$requireCreate)) {
            throw new IOException($this$requireCreate + " already exists.");
        }
    }
}

