/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql;

import org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astratemplate.shade.kotlin.Metadata;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.Reflection;
import ru.astrainteractive.astratemplate.shade.kotlin.text.StringsKt;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.ColumnType;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.MysqlDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0015\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/FloatColumnType;", "Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/ColumnType;", "", "<init>", "()V", "sqlType", "", "valueFromDB", "value", "", "(Ljava/lang/Object;)Ljava/lang/Float;", "nonNullValueAsDefaultString", "exposed-core"})
public final class FloatColumnType
extends ColumnType<Float> {
    public FloatColumnType() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().floatType();
    }

    @Override
    @NotNull
    public Float valueFromDB(@NotNull Object value) {
        float f;
        Intrinsics.checkNotNullParameter(value, "value");
        Object object = value;
        if (object instanceof Float) {
            f = ((Number)value).floatValue();
        } else if (object instanceof Number) {
            f = ((Number)value).floatValue();
        } else if (object instanceof String) {
            f = Float.parseFloat((String)value);
        } else {
            throw new IllegalStateException(("Unexpected value of type Float: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        return Float.valueOf(f);
    }

    @Override
    @NotNull
    public String nonNullValueAsDefaultString(float value) {
        String it = String.valueOf(value);
        boolean bl = false;
        return DatabaseDialectKt.getCurrentDialect() instanceof MysqlDialect && StringsKt.endsWith$default(it, ".0", false, 2, null) ? StringsKt.replace$default(it, ".0", "", false, 4, null) : it;
    }
}

