/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.javatime;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.astrainteractive.astratemplate.shade.kotlin.Metadata;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.DefaultConstructorMarker;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.astratemplate.shade.kotlin.text.StringsKt;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.ColumnType;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.IDateColumnType;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.javatime.JavaDateColumnTypeKt;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.transactions.TransactionManager;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.H2Dialect;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.H2Kt;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.MariaDBDialect;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.MysqlDialect;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.OracleDialect;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/javatime/JavaInstantColumnType;", "Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/ColumnType;", "Ljava/time/Instant;", "Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/IDateColumnType;", "<init>", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "sqlType", "", "nonNullValueToString", "value", "valueFromDB", "", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "notNullValueToDB", "nonNullValueAsDefaultString", "Companion", "exposed-java-time"})
public final class JavaInstantColumnType
extends ColumnType<Instant>
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final JavaInstantColumnType INSTANCE = new JavaInstantColumnType();

    public JavaInstantColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    @Override
    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().timestampType();
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Instant value) {
        String string;
        Intrinsics.checkNotNullParameter(value, "value");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (dialect instanceof OracleDialect) {
            string = JavaDateColumnTypeKt.access$oracleTimestampLiteral(value);
        } else if (dialect instanceof SQLiteDialect) {
            string = '\'' + JavaDateColumnTypeKt.access$getSQLITE_AND_ORACLE_TIMESTAMP_STRING_FORMATTER().format(value) + '\'';
        } else if (dialect instanceof MysqlDialect) {
            DateTimeFormatter formatter = ((MysqlDialect)dialect).isFractionDateTimeSupported() ? JavaDateColumnTypeKt.access$getMYSQL_FRACTION_TIMESTAMP_STRING_FORMATTER() : JavaDateColumnTypeKt.access$getMYSQL_TIMESTAMP_STRING_FORMATTER();
            string = '\'' + formatter.format(value) + '\'';
        } else {
            string = '\'' + JavaDateColumnTypeKt.access$getDEFAULT_TIMESTAMP_STRING_FORMATTER().format(value) + '\'';
        }
        return string;
    }

    @Override
    @NotNull
    public Instant valueFromDB(@NotNull Object value) {
        Instant instant;
        Intrinsics.checkNotNullParameter(value, "value");
        Object object = value;
        if (object instanceof Timestamp) {
            Instant instant2 = ((Timestamp)value).toInstant();
            instant = instant2;
            Intrinsics.checkNotNullExpressionValue(instant2, "toInstant(...)");
        } else if (object instanceof String) {
            Instant instant3 = Instant.parse((CharSequence)value);
            instant = instant3;
            Intrinsics.checkNotNullExpressionValue(instant3, "parse(...)");
        } else {
            instant = this.valueFromDB(value.toString());
        }
        return instant;
    }

    @Override
    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter(rs, "rs");
        return rs.getTimestamp(index);
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull Instant value) {
        Object object;
        Intrinsics.checkNotNullParameter(value, "value");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (dialect instanceof SQLiteDialect) {
            object = JavaDateColumnTypeKt.access$getSQLITE_AND_ORACLE_TIMESTAMP_STRING_FORMATTER().format(value);
        } else if (dialect instanceof MysqlDialect && !(dialect instanceof MariaDBDialect) && !TransactionManager.Companion.current().getDb().isVersionCovers(8, 0)) {
            DateTimeFormatter formatter = ((MysqlDialect)dialect).isFractionDateTimeSupported() ? JavaDateColumnTypeKt.access$getMYSQL_FRACTION_TIMESTAMP_STRING_FORMATTER() : JavaDateColumnTypeKt.access$getMYSQL_TIMESTAMP_STRING_FORMATTER();
            object = formatter.format(value);
        } else {
            object = Timestamp.from(value);
        }
        return object;
    }

    @Override
    @NotNull
    public String nonNullValueAsDefaultString(@NotNull Instant value) {
        String string;
        Intrinsics.checkNotNullParameter(value, "value");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (dialect instanceof PostgreSQLDialect) {
            StringBuilder stringBuilder = new StringBuilder().append('\'');
            String string2 = JavaDateColumnTypeKt.access$getSQLITE_AND_ORACLE_TIMESTAMP_STRING_FORMATTER().format(value);
            Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
            char[] cArray = new char[]{'0'};
            String string3 = StringsKt.trimEnd(string2, cArray);
            cArray = new char[]{'.'};
            string = stringBuilder.append(StringsKt.trimEnd(string3, cArray)).append("'::timestamp without time zone").toString();
        } else if (H2Kt.getH2Mode(dialect) == H2Dialect.H2CompatibilityMode.Oracle) {
            StringBuilder stringBuilder = new StringBuilder().append('\'');
            String string4 = JavaDateColumnTypeKt.access$getSQLITE_AND_ORACLE_TIMESTAMP_STRING_FORMATTER().format(value);
            Intrinsics.checkNotNullExpressionValue(string4, "format(...)");
            char[] cArray = new char[]{'0'};
            String string5 = StringsKt.trimEnd(string4, cArray);
            cArray = new char[]{'.'};
            string = stringBuilder.append(StringsKt.trimEnd(string5, cArray)).append('\'').toString();
        } else {
            string = super.nonNullValueAsDefaultString(value);
        }
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/javatime/JavaInstantColumnType$Companion;", "", "<init>", "()V", "INSTANCE", "Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/javatime/JavaInstantColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/javatime/JavaInstantColumnType;", "exposed-java-time"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaInstantColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

