/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.javatime;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.astrainteractive.astratemplate.shade.kotlin.Metadata;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.DefaultConstructorMarker;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.ColumnType;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.IDateColumnType;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.javatime.JavaDateColumnTypeKt;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.OracleDialect;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.PostgreSQLDialect;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001d\u0010\u0012\u001a\n \u0013*\u0004\u0018\u00010\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/javatime/JavaLocalDateColumnType;", "Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/ColumnType;", "Ljava/time/LocalDate;", "Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/IDateColumnType;", "<init>", "()V", "hasTimePart", "", "getHasTimePart", "()Z", "sqlType", "", "nonNullValueToString", "value", "valueFromDB", "", "notNullValueToDB", "nonNullValueAsDefaultString", "longToLocalDate", "ru.astrainteractive.astratemplate.shade.kotlin.jvm.PlatformType", "instant", "", "(J)Ljava/time/LocalDate;", "Companion", "exposed-java-time"})
public final class JavaLocalDateColumnType
extends ColumnType<LocalDate>
implements IDateColumnType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hasTimePart;
    @NotNull
    private static final JavaLocalDateColumnType INSTANCE = new JavaLocalDateColumnType();

    public JavaLocalDateColumnType() {
        super(false, 1, null);
    }

    @Override
    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().dateType();
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull LocalDate value) {
        Intrinsics.checkNotNullParameter(value, "value");
        Instant instant = Instant.from(value.atStartOfDay(ZoneId.systemDefault()));
        String formatted = JavaDateColumnTypeKt.access$getDEFAULT_DATE_STRING_FORMATTER().format(instant);
        if (DatabaseDialectKt.getCurrentDialect() instanceof OracleDialect) {
            Intrinsics.checkNotNull(instant);
            return JavaDateColumnTypeKt.access$oracleDateLiteral(instant);
        }
        return '\'' + formatted + '\'';
    }

    @Override
    @Nullable
    public LocalDate valueFromDB(@NotNull Object value) {
        Intrinsics.checkNotNullParameter(value, "value");
        Object object = value;
        return object instanceof LocalDate ? (LocalDate)value : (object instanceof Date ? this.longToLocalDate(((Date)value).getTime()) : (object instanceof Timestamp ? this.longToLocalDate(((Timestamp)value).getTime()) : (object instanceof Integer ? this.longToLocalDate(((Number)value).intValue()) : (object instanceof Long ? this.longToLocalDate(((Number)value).longValue()) : (object instanceof String ? LocalDate.parse((CharSequence)value) : LocalDate.parse(value.toString()))))));
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull LocalDate value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? JavaDateColumnTypeKt.access$getDEFAULT_DATE_STRING_FORMATTER().format(value) : new Date(JavaDateColumnTypeKt.access$getMillis(value));
    }

    @Override
    @NotNull
    public String nonNullValueAsDefaultString(@NotNull LocalDate value) {
        Intrinsics.checkNotNullParameter(value, "value");
        return DatabaseDialectKt.getCurrentDialect() instanceof PostgreSQLDialect ? this.nonNullValueToString(value) + "::date" : super.nonNullValueAsDefaultString(value);
    }

    private final LocalDate longToLocalDate(long instant) {
        return Instant.ofEpochMilli(instant).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/javatime/JavaLocalDateColumnType$Companion;", "", "<init>", "()V", "INSTANCE", "Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/javatime/JavaLocalDateColumnType;", "getINSTANCE$exposed_java_time", "()Lorg/jetbrains/exposed/sql/javatime/JavaLocalDateColumnType;", "exposed-java-time"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JavaLocalDateColumnType getINSTANCE$exposed_java_time() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

