/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors;

import java.math.BigDecimal;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astratemplate.shade.kotlin.Lazy;
import ru.astrainteractive.astratemplate.shade.kotlin.LazyKt;
import ru.astrainteractive.astratemplate.shade.kotlin.Metadata;
import ru.astrainteractive.astratemplate.shade.kotlin.collections.CollectionsKt;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.DefaultConstructorMarker;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.astratemplate.shade.kotlin.text.StringsKt;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.Expression;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.ExpressionWithColumnType;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.Index;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.SQLLogKt;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.Schema;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.Table;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.transactions.TransactionManager;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.MysqlDataTypeProvider;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.MysqlFunctionProvider;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 32\u00020\u0001:\u00013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016J\u0014\u0010\u001f\u001a\u00020\u00052\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!H\u0016J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020$H\u0016J(\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005H\u0016J\u0010\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,H\u0016J\u0018\u0010.\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,2\u0006\u0010/\u001a\u00020\u0005H\u0016J\u001c\u00100\u001a\u00020\u0005*\u00020\u000b2\u0006\u0010+\u001a\u00020\u000b2\u0006\u00101\u001a\u000202H\u0014R\u001b\u0010\u0004\u001a\u00020\u00058@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0007R\u0014\u0010\u0011\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0007R\u0014\u0010\u0013\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0007R\u0014\u0010\u0015\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0007R\u0014\u0010\u0017\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0007R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001cX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u00064"}, d2={"Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/vendors/MysqlDialect;", "Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/vendors/VendorDialect;", "<init>", "()V", "isMysql8", "", "isMysql8$exposed_core", "()Z", "isMysql8$delegate", "Lru/astrainteractive/astratemplate/shade/kotlin/Lazy;", "fullVersion", "", "getFullVersion$exposed_core", "()Ljava/lang/String;", "fullVersion$delegate", "supportsCreateSequence", "getSupportsCreateSequence", "supportsTernaryAffectedRowValues", "getSupportsTernaryAffectedRowValues", "supportsSubqueryUnions", "getSupportsSubqueryUnions", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "supportsSetDefaultReferenceOption", "getSupportsSetDefaultReferenceOption", "isFractionDateTimeSupported", "isTimeZoneOffsetSupported", "notAcceptableDefaults", "", "getNotAcceptableDefaults", "()Ljava/util/List;", "isAllowedAsColumnDefault", "e", "Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/Expression;", "createIndex", "index", "Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/Index;", "dropIndex", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "setSchema", "schema", "Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/Schema;", "createSchema", "dropSchema", "cascade", "metadataMatchesTable", "table", "Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/Table;", "Companion", "exposed-core"})
public class MysqlDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy isMysql8$delegate = LazyKt.lazy(MysqlDialect::isMysql8_delegate$lambda$0);
    @NotNull
    private final Lazy fullVersion$delegate = LazyKt.lazy(MysqlDialect::fullVersion_delegate$lambda$2);
    private final boolean supportsCreateSequence;
    private final boolean supportsTernaryAffectedRowValues;
    private final boolean supportsSubqueryUnions;
    private final boolean supportsOrderByNullsFirstLast;
    private final boolean supportsSetDefaultReferenceOption;
    @NotNull
    private final List<String> notAcceptableDefaults;

    public MysqlDialect() {
        super(Companion.getDialectName(), MysqlDataTypeProvider.Companion.getINSTANCE$exposed_core(), MysqlFunctionProvider.Companion.getINSTANCE$exposed_core());
        this.supportsTernaryAffectedRowValues = true;
        this.supportsSubqueryUnions = true;
        String[] stringArray = new String[]{"CURRENT_DATE()", "CURRENT_DATE"};
        this.notAcceptableDefaults = CollectionsKt.mutableListOf(stringArray);
    }

    public final boolean isMysql8$exposed_core() {
        Lazy lazy = this.isMysql8$delegate;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final String getFullVersion$exposed_core() {
        Lazy lazy = this.fullVersion$delegate;
        return (String)lazy.getValue();
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return this.supportsCreateSequence;
    }

    @Override
    public boolean getSupportsTernaryAffectedRowValues() {
        return this.supportsTernaryAffectedRowValues;
    }

    @Override
    public boolean getSupportsSubqueryUnions() {
        return this.supportsSubqueryUnions;
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return this.supportsOrderByNullsFirstLast;
    }

    @Override
    public boolean getSupportsSetDefaultReferenceOption() {
        return this.supportsSetDefaultReferenceOption;
    }

    public boolean isFractionDateTimeSupported() {
        return TransactionManager.Companion.current().getDb().isVersionCovers(5, 6);
    }

    public boolean isTimeZoneOffsetSupported() {
        return this.isMysql8$exposed_core();
    }

    @NotNull
    protected final List<String> getNotAcceptableDefaults() {
        return this.notAcceptableDefaults;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (super.isAllowedAsColumnDefault(e)) {
            return true;
        }
        if (this.getFullVersion$exposed_core().compareTo("8.0.13") >= 0) {
            return true;
        }
        return !this.notAcceptableDefaults.contains(((Object)StringsKt.trim((CharSequence)e.toString())).toString());
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter(index, "index");
        if (index.getFunctions() != null && !this.isMysql8$exposed_core()) {
            SQLLogKt.getExposedLogger().warn("Functional index on " + index.getTable().getTableName() + " using " + CollectionsKt.joinToString$default(index.getFunctions(), null, null, null, 0, null, MysqlDialect::createIndex$lambda$3, 31, null) + " can't be created in MySQL prior to 8.0");
            return "";
        }
        return super.createIndex(index);
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName, boolean isUnique, boolean isPartialOrFunctional) {
        Intrinsics.checkNotNullParameter(tableName, "tableName");
        Intrinsics.checkNotNullParameter(indexName, "indexName");
        return "ALTER TABLE " + this.getIdentifierManager().quoteIfNecessary(tableName) + " DROP INDEX " + this.getIdentifierManager().quoteIfNecessary(indexName);
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        return "USE " + schema.getIdentifier();
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(schema, "schema");
        StringBuilder $this$createSchema_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"CREATE SCHEMA IF NOT EXISTS ", schema.getIdentifier()};
        StringsKt.append($this$createSchema_u24lambda_u244, stringArray);
        if (schema.getAuthorization() != null) {
            throw new UnsupportedByDialectException(DatabaseDialectKt.getCurrentDialect().getName() + " do not have database owners. You can use GRANT to allow or deny rights on database.", DatabaseDialectKt.getCurrentDialect());
        }
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        return "DROP SCHEMA IF EXISTS " + schema.getIdentifier();
    }

    @Override
    protected boolean metadataMatchesTable(@NotNull String $this$metadataMatchesTable, @NotNull String schema, @NotNull Table table) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$metadataMatchesTable, "<this>");
        Intrinsics.checkNotNullParameter(schema, "schema");
        Intrinsics.checkNotNullParameter(table, "table");
        if (((CharSequence)schema).length() == 0) {
            bl = Intrinsics.areEqual($this$metadataMatchesTable, table.nameInDatabaseCaseUnquoted());
        } else {
            String sanitizedTableName = StringsKt.replace$default(table.getTableNameWithoutScheme$exposed_core(), "`", "", false, 4, null);
            String nameInDb = DatabaseDialectKt.inProperCase(schema + '.' + sanitizedTableName);
            bl = Intrinsics.areEqual($this$metadataMatchesTable, nameInDb);
        }
        return bl;
    }

    private static final boolean isMysql8_delegate$lambda$0() {
        return TransactionManager.Companion.current().getDb().isVersionCovers(new BigDecimal("8.0"));
    }

    private static final String fullVersion_delegate$lambda$2$lambda$1(ExposedDatabaseMetadata $this$metadata) {
        Intrinsics.checkNotNullParameter($this$metadata, "$this$metadata");
        return $this$metadata.getDatabaseProductVersion();
    }

    private static final String fullVersion_delegate$lambda$2() {
        return TransactionManager.Companion.current().getDb().metadata$exposed_core(MysqlDialect::fullVersion_delegate$lambda$2$lambda$1);
    }

    private static final CharSequence createIndex$lambda$3(ExpressionWithColumnType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.toString();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/vendors/MysqlDialect$Companion;", "Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/vendors/VendorDialect$DialectNameProvider;", "<init>", "()V", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("MySQL");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

