/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors;

import java.util.Locale;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import ru.astrainteractive.astratemplate.shade.kotlin.Metadata;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.astratemplate.shade.kotlin.text.StringsKt;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.SQLLogKt;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.DataTypeProvider;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.DatabaseDialect;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.H2DataTypeProvider;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.H2Dialect;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.vendors.H2Kt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0005H\u0016J\b\u0010 \u001a\u00020\u0005H\u0016J\u0010\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\b\u0010%\u001a\u00020\u0005H\u0016J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005H\u0016\u00a8\u0006("}, d2={"Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/vendors/OracleDataTypeProvider;", "Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/vendors/DataTypeProvider;", "<init>", "()V", "byteType", "", "ubyteType", "shortType", "ushortType", "integerType", "integerAutoincType", "uintegerType", "uintegerAutoincType", "longType", "longAutoincType", "ulongType", "ulongAutoincType", "varcharType", "colLength", "", "textType", "mediumTextType", "largeTextType", "timeType", "binaryType", "length", "uuidType", "uuidToDB", "", "value", "Ljava/util/UUID;", "dateTimeType", "booleanType", "booleanToStatementString", "bool", "", "booleanFromStringToBoolean", "jsonType", "hexToDb", "hexString", "exposed-core"})
public final class OracleDataTypeProvider
extends DataTypeProvider {
    @NotNull
    public static final OracleDataTypeProvider INSTANCE = new OracleDataTypeProvider();

    private OracleDataTypeProvider() {
    }

    @Override
    @NotNull
    public String byteType() {
        return H2Kt.getH2Mode(DatabaseDialectKt.getCurrentDialect()) == H2Dialect.H2CompatibilityMode.Oracle ? "TINYINT" : "NUMBER(3)";
    }

    @Override
    @NotNull
    public String ubyteType() {
        return "NUMBER(3)";
    }

    @Override
    @NotNull
    public String shortType() {
        return H2Kt.getH2Mode(DatabaseDialectKt.getCurrentDialect()) == H2Dialect.H2CompatibilityMode.Oracle ? "SMALLINT" : "NUMBER(5)";
    }

    @Override
    @NotNull
    public String ushortType() {
        return "NUMBER(5)";
    }

    @Override
    @NotNull
    public String integerType() {
        return H2Kt.getH2Mode(DatabaseDialectKt.getCurrentDialect()) == H2Dialect.H2CompatibilityMode.Oracle ? "INTEGER" : "NUMBER(10)";
    }

    @Override
    @NotNull
    public String integerAutoincType() {
        return this.integerType();
    }

    @Override
    @NotNull
    public String uintegerType() {
        return "NUMBER(10)";
    }

    @Override
    @NotNull
    public String uintegerAutoincType() {
        return "NUMBER(10)";
    }

    @Override
    @NotNull
    public String longType() {
        return H2Kt.getH2Mode(DatabaseDialectKt.getCurrentDialect()) == H2Dialect.H2CompatibilityMode.Oracle ? "BIGINT" : "NUMBER(19)";
    }

    @Override
    @NotNull
    public String longAutoincType() {
        return this.longType();
    }

    @Override
    @NotNull
    public String ulongType() {
        return "NUMBER(20)";
    }

    @Override
    @NotNull
    public String ulongAutoincType() {
        return "NUMBER(20)";
    }

    @Override
    @NotNull
    public String varcharType(int colLength) {
        return "VARCHAR2(" + colLength + " CHAR)";
    }

    @Override
    @NotNull
    public String textType() {
        return "CLOB";
    }

    @Override
    @NotNull
    public String mediumTextType() {
        return this.textType();
    }

    @Override
    @NotNull
    public String largeTextType() {
        return this.textType();
    }

    @Override
    @NotNull
    public String timeType() {
        return this.dateTimeType();
    }

    @Override
    @NotNull
    public String binaryType() {
        SQLLogKt.getExposedLogger().error("Binary type is unsupported for Oracle. Please use blob column type instead.");
        throw new IllegalStateException("Binary type is unsupported for Oracle. Please use blob column type instead.".toString());
    }

    @Override
    @NotNull
    public String binaryType(int length) {
        return length < 2000 ? "RAW(" + length + ')' : this.binaryType();
    }

    @Override
    @NotNull
    public String uuidType() {
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        H2Dialect h2Dialect = databaseDialect instanceof H2Dialect ? (H2Dialect)databaseDialect : null;
        return (h2Dialect != null ? h2Dialect.getH2Mode() : null) == H2Dialect.H2CompatibilityMode.Oracle ? "UUID" : "RAW(16)";
    }

    @Override
    @NotNull
    public Object uuidToDB(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter(value, "value");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        H2Dialect h2Dialect = databaseDialect instanceof H2Dialect ? (H2Dialect)databaseDialect : null;
        return (h2Dialect != null ? h2Dialect.getH2Mode() : null) == H2Dialect.H2CompatibilityMode.Oracle ? H2DataTypeProvider.INSTANCE.uuidToDB(value) : super.uuidToDB(value);
    }

    @Override
    @NotNull
    public String dateTimeType() {
        return "TIMESTAMP";
    }

    @Override
    @NotNull
    public String booleanType() {
        return "CHAR(1)";
    }

    @Override
    @NotNull
    public String booleanToStatementString(boolean bool) {
        return bool ? "1" : "0";
    }

    @Override
    public boolean booleanFromStringToBoolean(@NotNull String value) {
        boolean bl;
        Intrinsics.checkNotNullParameter(value, "value");
        try {
            bl = Long.parseLong(value) != 0L;
        }
        catch (NumberFormatException ex) {
            boolean bl2;
            try {
                String string = value.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
                bl2 = StringsKt.toBooleanStrict(string);
            }
            catch (IllegalArgumentException ex2) {
                throw new IllegalStateException(("Unexpected value of type Boolean: " + value).toString());
            }
            bl = bl2;
        }
        return bl;
    }

    @Override
    @NotNull
    public String jsonType() {
        return "VARCHAR2(4000)";
    }

    @Override
    @NotNull
    public String hexToDb(@NotNull String hexString) {
        Intrinsics.checkNotNullParameter(hexString, "hexString");
        return "HEXTORAW('" + hexString + "')";
    }
}

