/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astratemplate.shade.ru.astrainteractive.astralibs.exposed.model;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.astrainteractive.astratemplate.shade.kotlin.Metadata;
import ru.astrainteractive.astratemplate.shade.kotlin.NoWhenBranchMatchedException;
import ru.astrainteractive.astratemplate.shade.kotlin.Unit;
import ru.astrainteractive.astratemplate.shade.kotlin.io.FilesKt;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.astratemplate.shade.kotlin.time.Duration;
import ru.astrainteractive.astratemplate.shade.kotlin.time.DurationKt;
import ru.astrainteractive.astratemplate.shade.kotlin.time.DurationUnit;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.Database;
import ru.astrainteractive.astratemplate.shade.org.jetbrains.exposed.sql.DatabaseConfig;
import ru.astrainteractive.astratemplate.shade.ru.astrainteractive.astralibs.exposed.model.DatabaseConfiguration;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001e\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\t"}, d2={"getUrl", "", "Lru/astrainteractive/astratemplate/shade/ru/astrainteractive/astralibs/exposed/model/DatabaseConfiguration;", "dataFolder", "Ljava/io/File;", "connect", "Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/Database;", "databaseConfig", "Lru/astrainteractive/astratemplate/shade/org/jetbrains/exposed/sql/DatabaseConfig;", "exposed"})
public final class DatabaseConfigurationKt {
    @NotNull
    public static final String getUrl(@NotNull DatabaseConfiguration $this$getUrl, @NotNull File dataFolder) {
        String string;
        Intrinsics.checkNotNullParameter($this$getUrl, "<this>");
        Intrinsics.checkNotNullParameter(dataFolder, "dataFolder");
        DatabaseConfiguration databaseConfiguration = $this$getUrl;
        if (databaseConfiguration instanceof DatabaseConfiguration.H2) {
            string = "jdbc:h2:" + FilesKt.resolve(dataFolder, ((DatabaseConfiguration.H2)$this$getUrl).getName() + ".db").getAbsolutePath() + $this$getUrl.getStringArgument();
        } else if (databaseConfiguration instanceof DatabaseConfiguration.SQLite) {
            string = "jdbc:sqlite:" + FilesKt.resolve(dataFolder, ((DatabaseConfiguration.SQLite)$this$getUrl).getName() + ".db").getAbsolutePath() + $this$getUrl.getStringArgument();
        } else if (databaseConfiguration instanceof DatabaseConfiguration.MySql) {
            string = "jdbc:mysql://" + ((DatabaseConfiguration.MySql)$this$getUrl).getHost() + ":" + ((DatabaseConfiguration.MySql)$this$getUrl).getPort() + "/" + ((DatabaseConfiguration.MySql)$this$getUrl).getName() + $this$getUrl.getStringArgument();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public static final Database connect(@NotNull DatabaseConfiguration $this$connect, @NotNull File dataFolder, @Nullable DatabaseConfig databaseConfig) {
        Database database;
        Intrinsics.checkNotNullParameter($this$connect, "<this>");
        Intrinsics.checkNotNullParameter(dataFolder, "dataFolder");
        DatabaseConfiguration databaseConfiguration = $this$connect;
        if (databaseConfiguration instanceof DatabaseConfiguration.H2) {
            database = Database.Companion.connect$default(Database.Companion, DatabaseConfigurationKt.getUrl($this$connect, dataFolder), ((DatabaseConfiguration.H2)$this$connect).getDriver(), null, null, null, databaseConfig, null, null, 220, null);
        } else if (databaseConfiguration instanceof DatabaseConfiguration.MySql) {
            database = Database.Companion.connect$default(Database.Companion, DatabaseConfigurationKt.getUrl($this$connect, dataFolder), ((DatabaseConfiguration.MySql)$this$connect).getDriver(), ((DatabaseConfiguration.MySql)$this$connect).getUser(), ((DatabaseConfiguration.MySql)$this$connect).getPassword(), null, databaseConfig, null, null, 208, null);
        } else if (databaseConfiguration instanceof DatabaseConfiguration.SQLite) {
            database = Database.Companion.connect$default(Database.Companion, DatabaseConfigurationKt.getUrl($this$connect, dataFolder), ((DatabaseConfiguration.SQLite)$this$connect).getDriver(), null, null, null, databaseConfig, null, null, 220, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return database;
    }

    public static /* synthetic */ Database connect$default(DatabaseConfiguration databaseConfiguration, File file, DatabaseConfig databaseConfig, int n, Object object) {
        if ((n & 2) != 0) {
            databaseConfig = DatabaseConfig.Companion.invoke(DatabaseConfigurationKt::connect$lambda$0);
        }
        return DatabaseConfigurationKt.connect(databaseConfiguration, file, databaseConfig);
    }

    private static final Unit connect$lambda$0(DatabaseConfig.Builder $this$DatabaseConfig) {
        Intrinsics.checkNotNullParameter($this$DatabaseConfig, "$this$DatabaseConfig");
        $this$DatabaseConfig.setDefaultMinRetryDelay(Duration.getInWholeMilliseconds-impl(DurationKt.toDuration(5, DurationUnit.SECONDS)));
        $this$DatabaseConfig.setDefaultMaxRetryDelay(Duration.getInWholeMilliseconds-impl(DurationKt.toDuration(30, DurationUnit.SECONDS)));
        return Unit.INSTANCE;
    }
}

