/*
 * Decompiled with CFR 0.152.
 */
package ru.astrainteractive.astratemplate.shade.ru.astrainteractive.astralibs.logging;

import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.astrainteractive.astratemplate.shade.kotlin.ExceptionsKt;
import ru.astrainteractive.astratemplate.shade.kotlin.Metadata;
import ru.astrainteractive.astratemplate.shade.kotlin.collections.CollectionsKt;
import ru.astrainteractive.astratemplate.shade.kotlin.io.FilesKt;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.functions.Function0;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.DefaultConstructorMarker;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.Intrinsics;
import ru.astrainteractive.astratemplate.shade.kotlin.jvm.internal.SourceDebugExtension;
import ru.astrainteractive.astratemplate.shade.kotlin.text.StringsKt;
import ru.astrainteractive.astratemplate.shade.ru.astrainteractive.astralibs.logging.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\bH\u0002J\b\u0010\f\u001a\u00020\bH\u0002J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016J\u0016\u0010\u0011\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016J\u0016\u0010\u0012\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016J\u0016\u0010\u0013\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016J\u0016\u0010\u0014\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016J \u0010\u0011\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00152\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0002J\u0016\u0010\u0017\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lru/astrainteractive/astratemplate/shade/ru/astrainteractive/astralibs/logging/JUtilFileLogger;", "Lru/astrainteractive/astratemplate/shade/ru/astrainteractive/astralibs/logging/Logger;", "folder", "Ljava/io/File;", "instance", "<init>", "(Ljava/io/File;Lru/astrainteractive/astralibs/logging/Logger;)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "getTime", "getDate", "debug", "", "logMessage", "Lru/astrainteractive/astratemplate/shade/kotlin/Function0;", "error", "info", "verbose", "warn", "", "getLogFile", "logInFile", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nJUtilFileLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUtilFileLogger.kt\nru/astrainteractive/astralibs/logging/JUtilFileLogger\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,121:1\n18#2:122\n3829#3:123\n4344#3,2:124\n*S KotlinDebug\n*F\n+ 1 JUtilFileLogger.kt\nru/astrainteractive/astralibs/logging/JUtilFileLogger\n*L\n77#1:122\n78#1:123\n78#1:124,2\n*E\n"})
public final class JUtilFileLogger
implements Logger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File folder;
    @NotNull
    private final Logger instance;
    @NotNull
    private final String TAG;
    private static final int MAX_FILE_SIZE_MB = 0x800000;

    public JUtilFileLogger(@NotNull File folder, @NotNull Logger instance) {
        Intrinsics.checkNotNullParameter(folder, "folder");
        Intrinsics.checkNotNullParameter(instance, "instance");
        this.folder = folder;
        this.instance = instance;
        this.TAG = this.instance.getTAG();
    }

    @Override
    @NotNull
    public String getTAG() {
        return this.TAG;
    }

    private final String getTime() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        String string = formatter.format(now);
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        return string;
    }

    private final String getDate() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String string = formatter.format(now);
        Intrinsics.checkNotNullExpressionValue(string, "format(...)");
        return string;
    }

    @Override
    public void debug(@NotNull Function0<String> logMessage) {
        Intrinsics.checkNotNullParameter(logMessage, "logMessage");
        this.instance.debug(logMessage);
        this.logInFile(logMessage);
    }

    @Override
    public void error(@NotNull Function0<String> logMessage) {
        Intrinsics.checkNotNullParameter(logMessage, "logMessage");
        this.instance.error(logMessage);
        this.logInFile(logMessage);
    }

    @Override
    public void info(@NotNull Function0<String> logMessage) {
        Intrinsics.checkNotNullParameter(logMessage, "logMessage");
        this.instance.info(logMessage);
        this.logInFile(logMessage);
    }

    @Override
    public void verbose(@NotNull Function0<String> logMessage) {
        Intrinsics.checkNotNullParameter(logMessage, "logMessage");
        this.instance.verbose(logMessage);
        this.logInFile(logMessage);
    }

    @Override
    public void warn(@NotNull Function0<String> logMessage) {
        Intrinsics.checkNotNullParameter(logMessage, "logMessage");
        this.instance.warn(logMessage);
        this.logInFile(logMessage);
    }

    @Override
    public void error(@Nullable Throwable error, @NotNull Function0<String> logMessage) {
        Intrinsics.checkNotNullParameter(logMessage, "logMessage");
        this.instance.error(logMessage);
        Object object = error;
        if (object != null && (object = ExceptionsKt.stackTraceToString((Throwable)object)) != null) {
            Object stackTraceToString = object;
            boolean bl = false;
            this.logInFile(() -> JUtilFileLogger.error$lambda$1$lambda$0((String)stackTraceToString));
        }
        this.logInFile(logMessage);
    }

    /*
     * WARNING - void declaration
     */
    private final File getLogFile() {
        File file;
        Comparable<File> comparable;
        void $this$filterTo$iv$iv;
        if (!this.folder.exists()) {
            this.folder.mkdirs();
        }
        String data = this.getDate();
        File[] $this$orEmpty$iv = this.folder.listFiles();
        boolean $i$f$orEmpty = false;
        File[] fileArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            fileArray = new File[]{};
        }
        File[] $this$filter$iv = fileArray;
        boolean $i$f$filter22 = false;
        File[] fileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!StringsKt.startsWith$default(FilesKt.getNameWithoutExtension((File)it), data, false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator $i$f$filter22 = ((Iterable)((List)destination$iv$iv)).iterator();
        if (!$i$f$filter22.hasNext()) {
            comparable = null;
        } else {
            int n2;
            Comparable<File> it = (File)$i$f$filter22.next();
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!StringsKt.contains$default((CharSequence)FilesKt.getNameWithoutExtension((File)it), "-", false, 2, null)) {
                n2 = 0;
            } else {
                String[] $i$f$filterTo2 = new String[]{"-"};
                Object object = (String)CollectionsKt.lastOrNull(StringsKt.split$default((CharSequence)FilesKt.getNameWithoutExtension((File)it), $i$f$filterTo2, false, 0, 6, null));
                n2 = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
            }
            it = n2;
            while ($i$f$filter22.hasNext()) {
                Comparable comparable2;
                int n3;
                File it2 = (File)$i$f$filter22.next();
                $i$a$-maxOfOrNull-JUtilFileLogger$getLogFile$lastIndex$2 = false;
                Intrinsics.checkNotNull(it2);
                if (!StringsKt.contains$default((CharSequence)FilesKt.getNameWithoutExtension(it2), "-", false, 2, null)) {
                    n3 = 0;
                } else {
                    String[] stringArray = new String[]{"-"};
                    Object object = (String)CollectionsKt.lastOrNull(StringsKt.split$default((CharSequence)FilesKt.getNameWithoutExtension(it2), stringArray, false, 0, 6, null));
                    n3 = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
                }
                if (it.compareTo((File)(comparable2 = (Comparable)Integer.valueOf(n3))) >= 0) continue;
                it = comparable2;
            }
            comparable = it;
        }
        Integer lastIndex = (Integer)comparable;
        File lastFile = new File(this.folder, data + "-" + lastIndex + ".log");
        if (!lastFile.exists()) {
            lastFile.createNewFile();
            return lastFile;
        }
        float fileSizeMegaBytes = (float)lastFile.length() / 1024.0f / 1024.0f;
        if (fileSizeMegaBytes > 8388608.0f) {
            File newFile = new File(this.folder, data + "-" + lastIndex + ".log");
            newFile.createNewFile();
            file = newFile;
        } else {
            file = lastFile;
        }
        return file;
    }

    private final void logInFile(Function0<String> logMessage) {
        String time = this.getTime();
        File file = this.getLogFile();
        FilesKt.appendText$default(file, "[" + time + "] [" + this.getTAG() + "]: " + logMessage.invoke() + "\n", null, 2, null);
    }

    private static final String error$lambda$1$lambda$0(String $stackTraceToString) {
        return $stackTraceToString;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lru/astrainteractive/astratemplate/shade/ru/astrainteractive/astralibs/logging/JUtilFileLogger$Companion;", "", "<init>", "()V", "MAX_FILE_SIZE_MB", "", "toFileLogger", "Lru/astrainteractive/astratemplate/shade/ru/astrainteractive/astralibs/logging/JUtilFileLogger;", "Lru/astrainteractive/astratemplate/shade/ru/astrainteractive/astralibs/logging/Logger;", "folder", "Ljava/io/File;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JUtilFileLogger toFileLogger(@NotNull Logger $this$toFileLogger, @NotNull File folder) {
            Intrinsics.checkNotNullParameter($this$toFileLogger, "<this>");
            Intrinsics.checkNotNullParameter(folder, "folder");
            if (!(!($this$toFileLogger instanceof JUtilFileLogger))) {
                boolean bl = false;
                String string = $this$toFileLogger.getClass() + " already JUtilFileLogger!";
                throw new IllegalStateException(string.toString());
            }
            return new JUtilFileLogger(folder, $this$toFileLogger);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

