/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.cs.hudplus.handler;

import com.easeon.cs.core.EaseonClientCore;
import com.easeon.cs.core.api.EaseonFeatureEnumLike;
import com.easeon.cs.core.config.model.ToggleConfig;
import com.easeon.cs.hudplus.EaseonKeybinds;
import com.easeon.cs.hudplus.config.EaseonHudFeature;
import com.easeon.cs.hudplus.config.StringKey;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3966;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class ScreenHudRenderHandler {
    public static void render(class_332 context, class_9779 tickCounter) {
        class_1533 itemFrame;
        class_1799 stack;
        class_3966 ehr;
        class_1297 fullText2;
        class_239 bPos2;
        float scale;
        class_310 client = class_310.method_1551();
        if (client.field_1690.field_1842) {
            return;
        }
        class_327 tr = client.field_1772;
        int w = client.method_22683().method_4486();
        int h = client.method_22683().method_4502();
        ToggleConfig configClock = EaseonClientCore.getToggleConfig((EaseonFeatureEnumLike)EaseonHudFeature.SCREEN_TOP_CLOCK_DATE_OVERLAY);
        if (configClock.Enabled && client.field_1687 != null) {
            scale = 0.9f;
            long worldTime = client.field_1687.method_8532();
            long dayCount = worldTime / 24000L + 1L;
            long timeOfDay = worldTime % 24000L;
            int hour = (int)((timeOfDay / 1000L + 6L) % 24L);
            int minute = (int)(timeOfDay % 1000L * 60L / 1000L);
            String clockText = String.format("%02d:%02d", hour, minute);
            String dateText = String.format("Day %d", dayCount);
            int dateX = (int)(((float)w - (float)tr.method_1727(dateText) * scale) / 2.0f / scale);
            int clockX = (int)(((float)w - (float)tr.method_1727(clockText) * scale) / 2.0f / scale);
            ScreenHudRenderHandler.drawText(context, dateText, dateX, 3, scale, -1);
            Objects.requireNonNull(tr);
            ScreenHudRenderHandler.drawText(context, clockText, clockX, 9 + 5, scale, -1);
        }
        if (EaseonKeybinds.isZooming) {
            scale = 1.2f;
            int zoomValue = (int)EaseonKeybinds.getZoomLevel();
            String zoomText = String.format("x%d", zoomValue);
            int zoomX = (int)(((float)w - (float)tr.method_1727(zoomText) * scale) / 2.0f / scale);
            Objects.requireNonNull(tr);
            int zoomY = 9 * 2;
            ScreenHudRenderHandler.drawText(context, zoomText, zoomX, zoomY, scale, -2731);
        }
        ToggleConfig configCoords = EaseonClientCore.getToggleConfig((EaseonFeatureEnumLike)EaseonHudFeature.SCREEN_BOTTOM_COORDS_DIRECTION_HUD);
        if (configCoords.Enabled && client.field_1724 != null) {
            String[][] labels;
            String dirText = "  " + (switch (client.field_1724.method_5735()) {
                case class_2350.field_11043 -> StringKey.SCREEN_COORDS_DIRECTION_NORTH.asString(new Object[0]);
                case class_2350.field_11035 -> StringKey.SCREEN_COORDS_DIRECTION_SOUTH.asString(new Object[0]);
                case class_2350.field_11039 -> StringKey.SCREEN_COORDS_DIRECTION_WEST.asString(new Object[0]);
                case class_2350.field_11034 -> StringKey.SCREEN_COORDS_DIRECTION_EAST.asString(new Object[0]);
                default -> "-";
            });
            float scale2 = 0.8f;
            class_2338 bPos2 = client.field_1724.method_24515();
            String fullText2 = String.format("X: %d Y: %d Z: %d%s", bPos2.method_10263(), bPos2.method_10264(), bPos2.method_10260(), dirText);
            int cursor = (int)(((float)w - (float)tr.method_1727(fullText2) * scale2) / 2.0f / scale2);
            int y = (int)((float)(h - 68) / scale2);
            for (String[] pair : labels = new String[][]{{"X: ", String.valueOf(bPos2.method_10263())}, {" Y: ", String.valueOf(bPos2.method_10264())}, {" Z: ", String.valueOf(bPos2.method_10260())}}) {
                String prefix = pair[0];
                String value = pair[1];
                ScreenHudRenderHandler.drawText(context, prefix, cursor, y, scale2, -2731);
                ScreenHudRenderHandler.drawText(context, value, cursor += tr.method_1727(prefix), y, scale2, -1);
                cursor += tr.method_1727(value);
            }
            ScreenHudRenderHandler.drawText(context, dirText, cursor, y, scale2, -2731);
        }
        ToggleConfig itemFrameName = EaseonClientCore.getToggleConfig((EaseonFeatureEnumLike)EaseonHudFeature.SCREEN_ITEM_FRAME_ITEM_NAME);
        if (itemFrameName.Enabled && (bPos2 = client.field_1765) instanceof class_3966 && (fullText2 = (ehr = (class_3966)bPos2).method_17782()) instanceof class_1533 && !(stack = (itemFrame = (class_1533)fullText2).method_6940()).method_7960()) {
            String name = stack.method_7964().getString();
            int textWidth = tr.method_1727(name);
            int x = (w - textWidth) / 2;
            int y = h / 2 + 10;
            ScreenHudRenderHandler.drawText(context, name, x, y, 1.0f, -1);
        }
        ToggleConfig configFps = EaseonClientCore.getToggleConfig((EaseonFeatureEnumLike)EaseonHudFeature.SCREEN_TOP_LEFT_FPS_DISPLAY);
        if (configFps.Enabled) {
            float scale3 = 0.7f;
            int fps = client.method_47599();
            int fpsX = 2;
            int fpsY = 2;
            String fpsText = String.format("FPS: %d", fps);
            ScreenHudRenderHandler.drawText(context, fpsText, fpsX, fpsY, scale3, -1);
        }
    }

    private static void drawText(class_332 context, String text, int x, int y, float scale, int color) {
        class_310 client = class_310.method_1551();
        class_327 tr = client.field_1772;
        int w = client.method_22683().method_4486();
        context.method_51448().pushMatrix();
        context.method_51448().scale(scale, scale);
        context.method_25303(tr, text, x, y, color);
        context.method_51448().popMatrix();
    }
}

