/*
 * Decompiled with CFR 0.152.
 */
package com.procurer;

import com.procurer.Main;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class MiningBotEntity {
    private static final String BOT_NBT_KEY = "mining_bot_entity";
    private static final String BOT_OWNER_KEY = "mining_bot_owner";
    private static final String BOT_ACTIVE_KEY = "mining_bot_active";
    private final ArmorStand entity;
    private final UUID ownerId;
    private final Inventory inventory;
    private boolean isActive;
    private double hoverOffset = 0.0;
    private int animationTick = 0;
    private Location lastLocation = null;
    private int stuckTicks = 0;

    public MiningBotEntity(ArmorStand entity, UUID ownerId) {
        this.entity = entity;
        this.ownerId = ownerId;
        this.isActive = true;
        this.inventory = Bukkit.createInventory(null, (int)27, (String)("\u00a76Mining Bot Inventory - " + Bukkit.getOfflinePlayer((UUID)ownerId).getName()));
        this.setupEntity();
    }

    private void setupEntity() {
        this.entity.setVisible(true);
        this.entity.setGravity(false);
        this.entity.setCanPickupItems(false);
        this.entity.setCustomNameVisible(true);
        this.entity.setCustomName("\u00a76Mining Bot");
        this.entity.setSmall(true);
        this.entity.setArms(true);
        this.entity.setBasePlate(false);
        this.entity.setMarker(false);
        this.entity.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
        this.entity.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.ADDING_OR_CHANGING);
        this.entity.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.ADDING_OR_CHANGING);
        this.entity.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.ADDING_OR_CHANGING);
        this.entity.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.ADDING_OR_CHANGING);
        this.entity.addEquipmentLock(EquipmentSlot.OFF_HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
        NamespacedKey botKey = new NamespacedKey((Plugin)Main.getPlugin(Main.class), BOT_NBT_KEY);
        NamespacedKey ownerKey = new NamespacedKey((Plugin)Main.getPlugin(Main.class), BOT_OWNER_KEY);
        NamespacedKey activeKey = new NamespacedKey((Plugin)Main.getPlugin(Main.class), BOT_ACTIVE_KEY);
        PersistentDataContainer container = this.entity.getPersistentDataContainer();
        container.set(botKey, PersistentDataType.BOOLEAN, (Object)true);
        container.set(ownerKey, PersistentDataType.STRING, (Object)this.ownerId.toString());
        container.set(activeKey, PersistentDataType.BOOLEAN, (Object)true);
        ItemStack chestHead = new ItemStack(Material.CHEST);
        this.entity.getEquipment().setHelmet(chestHead);
        ItemStack pickaxe = new ItemStack(Material.DIAMOND_PICKAXE);
        this.entity.getEquipment().setItemInMainHand(pickaxe);
    }

    public void tick() {
        if (!this.entity.isValid()) {
            return;
        }
        ++this.animationTick;
        this.updateHoverAnimation();
        this.spawnIdleParticles();
        if (this.isActive) {
            this.followOwner();
        }
    }

    private void updateHoverAnimation() {
        this.hoverOffset = Math.sin((double)this.animationTick * 0.1) * 0.3;
        Location current = this.entity.getLocation();
        Location target = current.clone();
        target.setY(target.getY() + this.hoverOffset * 0.01);
        if (this.isSafeLocation(target)) {
            this.entity.teleport(target);
        }
    }

    private void spawnIdleParticles() {
        if (this.animationTick % 20 == 0) {
            Location loc = this.entity.getLocation().add(0.0, 1.0, 0.0);
            if (this.isActive) {
                this.entity.getWorld().spawnParticle(Particle.DUST, loc, 3, 0.3, 0.3, 0.3, 0.0, (Object)new Particle.DustOptions(Color.RED, 1.0f));
            } else {
                this.entity.getWorld().spawnParticle(Particle.SMOKE, loc, 1, 0.1, 0.1, 0.1, 0.01);
            }
        }
    }

    private void followOwner() {
        Player owner = Bukkit.getPlayer((UUID)this.ownerId);
        if (owner == null || !owner.isOnline()) {
            return;
        }
        Location botLoc = this.entity.getLocation();
        Location playerLoc = owner.getLocation();
        this.stuckTicks = this.lastLocation != null && botLoc.distance(this.lastLocation) < 0.1 ? ++this.stuckTicks : 0;
        this.lastLocation = botLoc.clone();
        double distance = botLoc.distance(playerLoc);
        if (this.stuckTicks > 60 || distance > 20.0) {
            this.teleportToSafeLocation(playerLoc);
            this.stuckTicks = 0;
            return;
        }
        if (distance > 5.0) {
            Location targetLoc = this.findSafeLocationNearPlayer(playerLoc);
            if (targetLoc != null) {
                Location newLoc = this.calculateSafeMovement(botLoc, targetLoc);
                if (newLoc != null) {
                    this.entity.teleport(newLoc);
                    if (this.animationTick % 5 == 0) {
                        this.entity.getWorld().spawnParticle(Particle.CLOUD, botLoc, 1, 0.1, 0.1, 0.1, 0.01);
                    }
                } else {
                    this.teleportToSafeLocation(playerLoc);
                }
            } else {
                this.teleportToSafeLocation(playerLoc);
            }
        }
    }

    private Location findSafeLocationNearPlayer(Location playerLoc) {
        double[] higherHeights;
        double[] heights;
        double[] offsets = new double[]{1.0, -1.0, 2.0, -2.0, 1.5, -1.5, 2.5, -2.5, 3.0, -3.0};
        for (double height : heights = new double[]{0.0, 0.5, -0.5, 1.0, -1.0}) {
            for (double x : offsets) {
                for (double z : offsets) {
                    Location testLoc = playerLoc.clone().add(x, height, z);
                    if (!this.isSafeLocation(testLoc)) continue;
                    return testLoc;
                }
            }
        }
        for (double height : higherHeights = new double[]{1.5, 2.0, 2.5}) {
            for (double x : offsets) {
                for (double z : offsets) {
                    Location testLoc = playerLoc.clone().add(x, height, z);
                    if (!this.isSafeLocation(testLoc)) continue;
                    return testLoc;
                }
            }
        }
        for (int y = -2; y <= 4; ++y) {
            for (int x = -4; x <= 4; ++x) {
                for (int z = -4; z <= 4; ++z) {
                    Location testLoc = playerLoc.clone().add((double)x, (double)y, (double)z);
                    if (!this.isSafeLocation(testLoc)) continue;
                    return testLoc;
                }
            }
        }
        return playerLoc.clone().add(1.0, 0.0, 1.0);
    }

    private boolean isSafeLocation(Location loc) {
        if (loc.getWorld() == null) {
            return false;
        }
        Location floor = loc.clone();
        Location head = loc.clone().add(0.0, 1.0, 0.0);
        return !floor.getBlock().isCollidable() && !head.getBlock().isCollidable();
    }

    private Location calculateSafeMovement(Location from, Location to) {
        Vector direction = to.toVector().subtract(from.toVector());
        double distance = direction.length();
        if (distance == 0.0) {
            return from;
        }
        direction.normalize().multiply(Math.min(0.3, distance));
        Location newLoc = from.clone().add(direction);
        if (this.isSafeLocation(newLoc)) {
            return newLoc;
        }
        Vector perpendicular = new Vector(-direction.getZ(), 0.0, direction.getX()).normalize().multiply(0.5);
        Location leftLoc = from.clone().add(direction.clone().add(perpendicular));
        if (this.isSafeLocation(leftLoc)) {
            return leftLoc;
        }
        Location rightLoc = from.clone().add(direction.clone().subtract(perpendicular));
        if (this.isSafeLocation(rightLoc)) {
            return rightLoc;
        }
        Location upLoc = newLoc.clone().add(0.0, 1.0, 0.0);
        if (this.isSafeLocation(upLoc)) {
            return upLoc;
        }
        Location downLoc = newLoc.clone().add(0.0, -1.0, 0.0);
        if (this.isSafeLocation(downLoc)) {
            return downLoc;
        }
        return null;
    }

    private void teleportToSafeLocation(Location playerLoc) {
        Location safeLoc = this.findSafeLocationNearPlayer(playerLoc);
        if (!this.isSafeLocation(safeLoc)) {
            for (int y = 0; y <= 10; ++y) {
                Location testLoc = playerLoc.clone().add(0.0, (double)y, 0.0);
                if (!this.isSafeLocation(testLoc)) continue;
                safeLoc = testLoc;
                break;
            }
            if (!this.isSafeLocation(safeLoc)) {
                for (int distance = 1; distance <= 5; ++distance) {
                    for (int angle = 0; angle < 360; angle += 45) {
                        double radians = Math.toRadians(angle);
                        double x = Math.cos(radians) * (double)distance;
                        double z = Math.sin(radians) * (double)distance;
                        Location testLoc = playerLoc.clone().add(x, 0.0, z);
                        if (!this.isSafeLocation(testLoc)) continue;
                        safeLoc = testLoc;
                        break;
                    }
                    if (this.isSafeLocation(safeLoc)) break;
                }
            }
        }
        this.entity.teleport(safeLoc);
        this.entity.getWorld().spawnParticle(Particle.PORTAL, safeLoc, 10, 0.3, 0.3, 0.3, 0.1);
    }

    public void setActive(boolean active) {
        this.isActive = active;
        NamespacedKey activeKey = new NamespacedKey((Plugin)Main.getPlugin(Main.class), BOT_ACTIVE_KEY);
        this.entity.getPersistentDataContainer().set(activeKey, PersistentDataType.BOOLEAN, (Object)active);
        if (active) {
            this.entity.setCustomName("\u00a76Mining Bot \u00a7a(Active)");
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, 1.5f);
        } else {
            this.entity.setCustomName("\u00a76Mining Bot \u00a7c(Inactive)");
            this.entity.getWorld().playSound(this.entity.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 1.0f, 0.8f);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public ArmorStand getEntity() {
        return this.entity;
    }

    public UUID getOwnerId() {
        return this.ownerId;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void remove() {
        this.entity.remove();
    }

    public static boolean isMiningBot(Entity entity) {
        if (!(entity instanceof ArmorStand)) {
            return false;
        }
        NamespacedKey key = new NamespacedKey((Plugin)Main.getPlugin(Main.class), BOT_NBT_KEY);
        return entity.getPersistentDataContainer().has(key, PersistentDataType.BOOLEAN);
    }

    public static UUID getBotOwner(Entity entity) {
        if (!MiningBotEntity.isMiningBot(entity)) {
            return null;
        }
        NamespacedKey key = new NamespacedKey((Plugin)Main.getPlugin(Main.class), BOT_OWNER_KEY);
        String ownerString = (String)entity.getPersistentDataContainer().get(key, PersistentDataType.STRING);
        if (ownerString != null) {
            try {
                return UUID.fromString(ownerString);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }
}

