/*
 * Decompiled with CFR 0.152.
 */
package com.procurer;

import com.procurer.Main;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class MiningBotItem {
    public static final String MINING_BOT_NBT_KEY = "mining_bot";
    public static final String INVENTORY_DATA_KEY = "inventory_data";

    public static ItemStack createMiningBot() {
        return MiningBotItem.createMiningBotWithInventory(null);
    }

    public static ItemStack createMiningBotWithInventory(Inventory inventory) {
        ItemStack item = new ItemStack(Material.RECOVERY_COMPASS);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a76\u00a7lMining Bot");
            ArrayList<String> lore = new ArrayList<String>(Arrays.asList("\u00a77A helpful bot that follows you around", "\u00a77and mines ores in your vicinity!", "", "\u00a7eRight-click \u00a77to spawn the bot", "\u00a7eRight-click bot \u00a77to open inventory", "\u00a7eLeft-click bot \u00a77to recall it"));
            if (inventory != null) {
                MiningBotItem.addInventoryToLore(lore, inventory);
            }
            lore.addAll(Arrays.asList("", "\u00a79Features:", "\u00a77\u2022 Follows the player around", "\u00a77\u2022 Mines visible ores automatically", "\u00a77\u2022 Has its own inventory", "\u00a77\u2022 Plays nice animations and sounds"));
            meta.setLore(lore);
            meta.addEnchant(Enchantment.UNBREAKING, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            NamespacedKey key = new NamespacedKey((Plugin)Main.getPlugin(Main.class), MINING_BOT_NBT_KEY);
            meta.getPersistentDataContainer().set(key, PersistentDataType.BOOLEAN, (Object)true);
            if (inventory != null) {
                MiningBotItem.saveInventoryToItem(meta, inventory);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private static void addInventoryToLore(List<String> lore, Inventory inventory) {
        HashMap<Material, Integer> itemCounts = new HashMap<Material, Integer>();
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType() == Material.AIR) continue;
            itemCounts.merge(item.getType(), item.getAmount(), Integer::sum);
        }
        if (!itemCounts.isEmpty()) {
            lore.add("");
            lore.add("\u00a76Current Inventory:");
            int count = 0;
            for (Map.Entry entry : itemCounts.entrySet()) {
                if (count >= 8) {
                    int remaining;
                    lore.add("\u00a77... and " + remaining + " more item type" + ((remaining = itemCounts.size() - count) > 1 ? "s" : ""));
                    break;
                }
                String itemName = MiningBotItem.formatItemName((Material)entry.getKey());
                lore.add("\u00a77\u2022 " + itemName + " \u00a7fx" + String.valueOf(entry.getValue()));
                ++count;
            }
        }
    }

    private static String formatItemName(Material material) {
        String name = material.name().toLowerCase().replace("_", " ");
        String[] words = name.split(" ");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            if (formatted.length() > 0) {
                formatted.append(" ");
            }
            formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1));
        }
        return formatted.toString();
    }

    public static void saveInventoryToItem(ItemMeta meta, Inventory inventory) {
        StringBuilder inventoryData = new StringBuilder();
        for (int i = 0; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null || item.getType() == Material.AIR) continue;
            if (inventoryData.length() > 0) {
                inventoryData.append(";");
            }
            inventoryData.append(i).append(":");
            inventoryData.append(item.getType().name()).append(":");
            inventoryData.append(item.getAmount());
        }
        NamespacedKey inventoryKey = new NamespacedKey((Plugin)Main.getPlugin(Main.class), INVENTORY_DATA_KEY);
        meta.getPersistentDataContainer().set(inventoryKey, PersistentDataType.STRING, (Object)inventoryData.toString());
    }

    public static void loadInventoryFromItem(ItemStack botItem, Inventory inventory) {
        if (botItem == null || !botItem.hasItemMeta()) {
            return;
        }
        ItemMeta meta = botItem.getItemMeta();
        NamespacedKey inventoryKey = new NamespacedKey((Plugin)Main.getPlugin(Main.class), INVENTORY_DATA_KEY);
        String inventoryData = (String)meta.getPersistentDataContainer().get(inventoryKey, PersistentDataType.STRING);
        if (inventoryData != null && !inventoryData.isEmpty()) {
            String[] items;
            for (String itemData : items = inventoryData.split(";")) {
                String[] parts;
                if (itemData.isEmpty() || (parts = itemData.split(":")).length != 3) continue;
                try {
                    int slot = Integer.parseInt(parts[0]);
                    Material material = Material.valueOf((String)parts[1]);
                    int amount = Integer.parseInt(parts[2]);
                    if (slot < 0 || slot >= inventory.getSize()) continue;
                    inventory.setItem(slot, new ItemStack(material, amount));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static boolean isMiningBot(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        NamespacedKey key = new NamespacedKey((Plugin)Main.getPlugin(Main.class), MINING_BOT_NBT_KEY);
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return container.has(key, PersistentDataType.BOOLEAN);
    }
}

