/*
 * Decompiled with CFR 0.152.
 */
package com.procurer;

import com.procurer.MiningBotEntity;
import com.procurer.MiningBotItem;
import com.procurer.MiningBotManager;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class MiningBotListener
implements Listener {
    private final JavaPlugin plugin;
    private final MiningBotManager botManager;

    public MiningBotListener(JavaPlugin plugin, MiningBotManager botManager) {
        this.plugin = plugin;
        this.botManager = botManager;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null || !MiningBotItem.isMiningBot(item)) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_AIR || event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            event.setCancelled(true);
            MiningBotEntity existingBot = this.botManager.getBotByOwner(player.getUniqueId());
            if (existingBot != null) {
                player.sendMessage("\u00a7cYou already have a mining bot active!");
                return;
            }
            Location spawnLoc = player.getLocation().add(2.0, 2.0, 0.0);
            MiningBotEntity bot = this.botManager.spawnBot(player, spawnLoc, item);
            item.setAmount(item.getAmount() - 1);
            player.getWorld().playSound(spawnLoc, Sound.ENTITY_ALLAY_AMBIENT_WITHOUT_ITEM, 1.0f, 1.2f);
            player.sendMessage("\u00a76Mining Bot spawned! Right-click to open inventory, left-click to recall.");
        }
    }

    @EventHandler
    public void onPlayerInteractAtEntity(PlayerInteractAtEntityEvent event) {
        if (!MiningBotEntity.isMiningBot(event.getRightClicked())) {
            return;
        }
        event.setCancelled(true);
        MiningBotEntity bot = this.botManager.getBotByEntity(event.getRightClicked());
        if (bot == null) {
            return;
        }
        Player player = event.getPlayer();
        if (!bot.getOwnerId().equals(player.getUniqueId())) {
            player.sendMessage("\u00a7cThis is not your mining bot!");
            return;
        }
        player.openInventory(bot.getInventory());
        player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        if (!MiningBotEntity.isMiningBot(event.getEntity())) {
            return;
        }
        event.setCancelled(true);
        if (event.getDamager() instanceof Player) {
            Player player = (Player)event.getDamager();
            MiningBotEntity bot = this.botManager.getBotByEntity(event.getEntity());
            if (bot != null && bot.getOwnerId().equals(player.getUniqueId())) {
                ItemStack botItem = MiningBotItem.createMiningBotWithInventory(bot.getInventory());
                this.botManager.removeBot(player.getUniqueId());
                player.getInventory().addItem(new ItemStack[]{botItem});
                player.sendMessage("\u00a76Mining Bot recalled!");
                player.getWorld().playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 1.0f, 1.0f);
            } else if (bot != null) {
                player.sendMessage("\u00a7cThis is not your mining bot!");
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (event.getView().getTitle().startsWith("\u00a76Mining Bot Inventory")) {
            // empty if block
        }
    }
}

