/*
 * Decompiled with CFR 0.152.
 */
package com.procurer;

import com.procurer.MiningBotEntity;
import com.procurer.MiningBotItem;
import com.procurer.OreDetector;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class MiningBotManager {
    private final JavaPlugin plugin;
    private final Map<UUID, MiningBotEntity> activeBots;
    private final OreDetector oreDetector;
    private BukkitTask updateTask;
    private BukkitTask miningTask;

    public MiningBotManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.activeBots = new HashMap<UUID, MiningBotEntity>();
        this.oreDetector = new OreDetector();
    }

    public void startTasks() {
        this.loadExistingBots();
        this.updateTask = new BukkitRunnable(){

            public void run() {
                for (MiningBotEntity bot : MiningBotManager.this.activeBots.values()) {
                    bot.tick();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        this.miningTask = new BukkitRunnable(){

            public void run() {
                for (MiningBotEntity bot : MiningBotManager.this.activeBots.values()) {
                    if (!bot.isActive()) continue;
                    MiningBotManager.this.performMining(bot);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private void performMining(MiningBotEntity bot) {
        Player owner = Bukkit.getPlayer((UUID)bot.getOwnerId());
        if (owner == null || !owner.isOnline()) {
            return;
        }
        this.oreDetector.mineNearbyOres(bot, owner);
    }

    public MiningBotEntity spawnBot(Player owner, Location location) {
        return this.spawnBot(owner, location, null);
    }

    public MiningBotEntity spawnBot(Player owner, Location location, ItemStack botItem) {
        this.removeBot(owner.getUniqueId());
        ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class);
        MiningBotEntity bot = new MiningBotEntity(armorStand, owner.getUniqueId());
        if (botItem != null) {
            MiningBotItem.loadInventoryFromItem(botItem, bot.getInventory());
        }
        this.activeBots.put(armorStand.getUniqueId(), bot);
        this.plugin.getLogger().info("Spawned mining bot for player: " + owner.getName());
        return bot;
    }

    public void removeBot(UUID ownerId) {
        MiningBotEntity toRemove = null;
        UUID entityToRemove = null;
        for (Map.Entry<UUID, MiningBotEntity> entry : this.activeBots.entrySet()) {
            if (!entry.getValue().getOwnerId().equals(ownerId)) continue;
            toRemove = entry.getValue();
            entityToRemove = entry.getKey();
            break;
        }
        if (toRemove != null) {
            toRemove.remove();
            this.activeBots.remove(entityToRemove);
        }
    }

    public MiningBotEntity getBotByEntity(Entity entity) {
        return this.activeBots.get(entity.getUniqueId());
    }

    public MiningBotEntity getBotByOwner(UUID ownerId) {
        for (MiningBotEntity bot : this.activeBots.values()) {
            if (!bot.getOwnerId().equals(ownerId)) continue;
            return bot;
        }
        return null;
    }

    public void shutdown() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
        }
        if (this.miningTask != null) {
            this.miningTask.cancel();
        }
        for (MiningBotEntity bot : this.activeBots.values()) {
            bot.remove();
        }
        this.activeBots.clear();
    }

    private void loadExistingBots() {
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                if (!MiningBotEntity.isMiningBot(entity) || !(entity instanceof ArmorStand)) continue;
                ArmorStand armorStand = (ArmorStand)entity;
                UUID ownerId = MiningBotEntity.getBotOwner(entity);
                if (ownerId == null) continue;
                MiningBotEntity bot = new MiningBotEntity(armorStand, ownerId);
                this.activeBots.put(armorStand.getUniqueId(), bot);
                this.plugin.getLogger().info("Loaded existing mining bot for player: " + String.valueOf(ownerId));
            }
        }
    }
}

