/*
 * Decompiled with CFR 0.152.
 */
package com.procurer;

import com.procurer.Main;
import com.procurer.MiningBotEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class OreDetector {
    private static final Set<Material> ORE_TYPES = Set.of(Material.COAL_ORE, Material.DEEPSLATE_COAL_ORE, Material.COPPER_ORE, Material.DEEPSLATE_COPPER_ORE, Material.IRON_ORE, Material.DEEPSLATE_IRON_ORE, Material.GOLD_ORE, Material.DEEPSLATE_GOLD_ORE, Material.REDSTONE_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.LAPIS_ORE, Material.DEEPSLATE_LAPIS_ORE, Material.DIAMOND_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.EMERALD_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.NETHER_GOLD_ORE, Material.NETHER_QUARTZ_ORE, Material.ANCIENT_DEBRIS);
    private final Map<Location, Long> lastMinedBlocks = new HashMap<Location, Long>();
    private static final long MINING_COOLDOWN = 3000L;

    public void mineNearbyOres(MiningBotEntity bot, Player owner) {
        Block targetOre;
        Location botLocation = bot.getEntity().getLocation();
        World world = botLocation.getWorld();
        if (world == null) {
            return;
        }
        this.cleanupOldEntries();
        Chunk chunk = botLocation.getChunk();
        List<Block> visibleOres = this.findVisibleOres(chunk, botLocation);
        if (!visibleOres.isEmpty() && (targetOre = this.findClosestOre(visibleOres, botLocation)) != null && this.canMineBlock(targetOre.getLocation())) {
            this.mineOre(bot, targetOre);
        }
    }

    private List<Block> findVisibleOres(Chunk chunk, Location botLocation) {
        ArrayList<Block> visibleOres = new ArrayList<Block>();
        World world = chunk.getWorld();
        int chunkX = chunk.getX() * 16;
        int chunkZ = chunk.getZ() * 16;
        for (int x = chunkX; x < chunkX + 16; ++x) {
            for (int z = chunkZ; z < chunkZ + 16; ++z) {
                for (int y = world.getMinHeight(); y < world.getMaxHeight(); ++y) {
                    Block block = world.getBlockAt(x, y, z);
                    if (!ORE_TYPES.contains(block.getType()) || !this.isOreVisible(block, botLocation)) continue;
                    visibleOres.add(block);
                }
            }
        }
        return visibleOres;
    }

    private boolean isOreVisible(Block ore, Location botLocation) {
        Location oreLocation = ore.getLocation().add(0.5, 0.5, 0.5);
        if (this.hasLineOfSight(botLocation, oreLocation)) {
            return true;
        }
        return this.isExposedToAir(ore);
    }

    private boolean hasLineOfSight(Location from, Location to) {
        World world = from.getWorld();
        if (world == null || !world.equals((Object)to.getWorld())) {
            return false;
        }
        Vector direction = to.toVector().subtract(from.toVector()).normalize();
        RayTraceResult result = world.rayTraceBlocks(from, direction, from.distance(to));
        if (result == null) {
            return true;
        }
        Block hitBlock = result.getHitBlock();
        return hitBlock != null && hitBlock.getLocation().equals((Object)to.getBlock().getLocation());
    }

    private boolean isExposedToAir(Block ore) {
        Location[] adjacentLocations;
        Location oreLocation = ore.getLocation();
        for (Location loc : adjacentLocations = new Location[]{oreLocation.clone().add(1.0, 0.0, 0.0), oreLocation.clone().add(-1.0, 0.0, 0.0), oreLocation.clone().add(0.0, 1.0, 0.0), oreLocation.clone().add(0.0, -1.0, 0.0), oreLocation.clone().add(0.0, 0.0, 1.0), oreLocation.clone().add(0.0, 0.0, -1.0)}) {
            Block adjacentBlock = loc.getBlock();
            if (adjacentBlock.getType() != Material.AIR && adjacentBlock.getType() != Material.CAVE_AIR && adjacentBlock.getType() != Material.VOID_AIR && !adjacentBlock.isLiquid()) continue;
            return true;
        }
        return false;
    }

    private Block findClosestOre(List<Block> ores, Location botLocation) {
        Block closest = null;
        double closestDistance = Double.MAX_VALUE;
        for (Block ore : ores) {
            double distance = ore.getLocation().distance(botLocation);
            if (!(distance < closestDistance) || !(distance <= 10.0)) continue;
            closest = ore;
            closestDistance = distance;
        }
        return closest;
    }

    private boolean canMineBlock(Location location) {
        Long lastMined = this.lastMinedBlocks.get(location);
        if (lastMined == null) {
            return true;
        }
        return System.currentTimeMillis() - lastMined > 3000L;
    }

    private void mineOre(final MiningBotEntity bot, final Block ore) {
        final Location oreLocation = ore.getLocation();
        final Location botLocation = bot.getEntity().getLocation();
        this.lastMinedBlocks.put(oreLocation, System.currentTimeMillis());
        Vector direction = oreLocation.toVector().subtract(botLocation.toVector()).normalize();
        Location newLookDirection = botLocation.clone();
        newLookDirection.setDirection(direction);
        bot.getEntity().teleport(newLookDirection);
        final World world = ore.getWorld();
        world.playSound(oreLocation, Sound.BLOCK_STONE_HIT, 1.0f, 1.0f);
        new BukkitRunnable(this){
            int stage = 0;
            final int maxStages = 10;

            public void run() {
                if (!bot.getEntity().isValid() || ore.getType() == Material.AIR) {
                    this.cancel();
                    return;
                }
                Location particleLoc = oreLocation.clone().add(0.5, 0.5, 0.5);
                world.spawnParticle(Particle.BLOCK, particleLoc, 5, 0.3, 0.3, 0.3, 0.1, (Object)ore.getBlockData());
                if (this.stage % 3 == 0) {
                    world.playSound(oreLocation, Sound.BLOCK_STONE_HIT, 0.8f, 1.0f + (float)this.stage * 0.1f);
                }
                ++this.stage;
                if (this.stage >= 10) {
                    world.playSound(oreLocation, Sound.BLOCK_STONE_BREAK, 1.0f, 1.0f);
                    world.spawnParticle(Particle.BLOCK, particleLoc, 15, 0.4, 0.4, 0.4, 0.2, (Object)ore.getBlockData());
                    Collection drops = ore.getDrops();
                    for (ItemStack drop : drops) {
                        HashMap leftover = bot.getInventory().addItem(new ItemStack[]{drop});
                        if (leftover.isEmpty()) continue;
                        for (ItemStack leftoverItem : leftover.values()) {
                            world.dropItemNaturally(botLocation, leftoverItem);
                        }
                    }
                    ore.setType(Material.AIR);
                    world.playSound(botLocation, Sound.ENTITY_ITEM_PICKUP, 0.5f, 1.2f);
                    world.spawnParticle(Particle.HAPPY_VILLAGER, botLocation.add(0.0, 1.0, 0.0), 3, 0.3, 0.3, 0.3, 0.0);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)Main.getPlugin(Main.class), 0L, 2L);
    }

    private void cleanupOldEntries() {
        long currentTime = System.currentTimeMillis();
        this.lastMinedBlocks.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 3000L);
    }
}

