/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.ctms.textures.entryTypes;

import fr.aeldit.ctms.Utils;
import fr.aeldit.ctms.textures.CTMSelector;
import fr.aeldit.ctms.textures.Group;
import fr.aeldit.ctms.textures.entryTypes.CTMBlock;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class CTMPack {
    private final String name;
    public final boolean isFolder;
    public final CTMSelector ctmSelector;
    private final List<CTMBlock> vanillaOnlyCtmBlocks;
    private final Map<String, List<CTMBlock>> namespaceBlocks;

    public CTMPack(@NotNull File file, @NotNull Map<String, List<CTMBlock>> namespacesBLocks) {
        this.name = file.getName();
        this.isFolder = true;
        boolean isVanilla = namespacesBLocks.size() == 1 && namespacesBLocks.containsKey("minecraft");
        this.vanillaOnlyCtmBlocks = isVanilla ? new ArrayList(namespacesBLocks.get("minecraft")) : null;
        this.namespaceBlocks = isVanilla ? null : namespacesBLocks;
        this.ctmSelector = this.hasCTMSelector(file) ? new CTMSelector(this.name, this) : null;
    }

    public CTMPack(@NotNull ZipFile zipFile, @NotNull Map<String, List<CTMBlock>> namespacesBLocks) {
        this.name = zipFile.getName().split(Utils.PATH_SEPARATOR)[zipFile.getName().split(Utils.PATH_SEPARATOR).length - 1];
        this.isFolder = false;
        boolean isVanilla = namespacesBLocks.size() == 1 && namespacesBLocks.containsKey("minecraft");
        this.vanillaOnlyCtmBlocks = isVanilla ? new ArrayList(namespacesBLocks.get("minecraft")) : null;
        this.namespaceBlocks = isVanilla ? null : namespacesBLocks;
        this.ctmSelector = this.hasCTMSelector(zipFile) ? new CTMSelector(this.name, zipFile, this) : null;
    }

    private boolean hasCTMSelector(File file) {
        return Files.exists(Path.of("%s/ctm_selector.json".formatted(file), new String[0]), new LinkOption[0]);
    }

    private boolean hasCTMSelector(@NotNull ZipFile zipFile) {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            if (!entries.nextElement().getName().equals("ctm_selector.json")) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public class_2561 getNameAsText() {
        return this.isFolder ? class_2561.method_30163((String)(this.name + " (folder)")) : class_2561.method_30163((String)this.name);
    }

    public List<CTMBlock> getCTMBlocks() {
        return this.vanillaOnlyCtmBlocks != null ? this.vanillaOnlyCtmBlocks : this.namespaceBlocks.values().stream().flatMap(Collection::stream).toList();
    }

    public List<CTMBlock> getCTMBlocksForNamespace(String namespace) {
        return this.namespaceBlocks.containsKey(namespace) ? this.namespaceBlocks.get(namespace) : new ArrayList(0);
    }

    public ArrayList<String> getNamespaces() {
        return this.vanillaOnlyCtmBlocks == null ? new ArrayList<String>(this.namespaceBlocks.keySet()) : new ArrayList<String>(List.of("minecraft"));
    }

    public boolean hasCtmSelector() {
        return this.ctmSelector != null;
    }

    public boolean isModded() {
        return this.vanillaOnlyCtmBlocks == null;
    }

    public boolean isBlockDisabledFromGroup(CTMBlock ctmBlock) {
        if (this.ctmSelector == null) {
            return false;
        }
        Group group = this.ctmSelector.getGroupWithBlock(ctmBlock);
        return group != null && !group.isEnabled();
    }

    public void toggle(CTMBlock block) {
        if (!this.isBlockDisabledFromGroup(block)) {
            block.toggle();
        }
    }

    public void resetOptions() {
        if (this.vanillaOnlyCtmBlocks != null) {
            this.vanillaOnlyCtmBlocks.stream().filter(ctmBlock -> !this.isBlockDisabledFromGroup((CTMBlock)ctmBlock)).forEach(ctmBlock -> ctmBlock.setEnabled(true));
        } else {
            this.namespaceBlocks.values().stream().flatMap(Collection::stream).filter(ctmBlock -> !this.isBlockDisabledFromGroup((CTMBlock)ctmBlock)).forEach(ctmBlock -> ctmBlock.setEnabled(true));
        }
    }

    public void resetNamespace(String namespace) {
        if (this.namespaceBlocks != null && this.namespaceBlocks.containsKey(namespace)) {
            this.namespaceBlocks.get(namespace).forEach(ctmBlock -> ctmBlock.setEnabled(true));
        }
    }
}

