/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.ctms.textures;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.aeldit.ctms.Utils;
import fr.aeldit.ctms.textures.Group;
import fr.aeldit.ctms.textures.entryTypes.CTMBlock;
import fr.aeldit.ctms.textures.entryTypes.CTMPack;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CTMSelector {
    private final List<Group> packGroups = new ArrayList<Group>();
    private final String packPath;
    private final boolean isFolder;

    public CTMSelector(@NotNull String packName, @NotNull CTMPack ctmPack) {
        this.packPath = "%s/%s".formatted(Utils.RESOURCE_PACKS_DIR, packName);
        this.isFolder = true;
        this.readFile();
        ctmPack.getCTMBlocks().forEach(ctmBlock -> this.packGroups.forEach(group -> group.addContainedBlock((CTMBlock)ctmBlock)));
    }

    public CTMSelector(@NotNull String packName, ZipFile zipFile, @NotNull CTMPack ctmPack) {
        this.packPath = "%s/%s".formatted(Utils.RESOURCE_PACKS_DIR, packName);
        this.isFolder = false;
        this.readFile(zipFile);
        ctmPack.getCTMBlocks().forEach(ctmBlock -> this.packGroups.forEach(group -> group.addContainedBlock((CTMBlock)ctmBlock)));
    }

    public List<Group> getGroups() {
        return this.packGroups;
    }

    @Nullable
    public Group getGroupWithBlock(@NotNull CTMBlock ctmBlock) {
        return this.packGroups.stream().filter(group -> group.containedBlocks.contains(ctmBlock)).findFirst().orElse(null);
    }

    private void readFile() {
        Path ctmSelectorPath = Path.of("%s/ctm_selector.json".formatted(this.packPath), new String[0]);
        if (Files.exists(ctmSelectorPath, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(ctmSelectorPath);){
                this.packGroups.addAll(Arrays.stream((Group.SerializableGroup[])new Gson().fromJson((Reader)reader, Group.SerializableGroup[].class)).map(sg -> new Group((Group.SerializableGroup)sg, true, this.packPath)).toList());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void readFile(@NotNull ZipFile zipFile) {
        try (InputStreamReader reader = new InputStreamReader(zipFile.getInputStream(zipFile.getEntry("ctm_selector.json")));){
            this.packGroups.addAll(Arrays.stream((Group.SerializableGroup[])new Gson().fromJson((Reader)reader, Group.SerializableGroup[].class)).map(sg -> new Group((Group.SerializableGroup)sg, false, this.packPath)).toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void resetOptions() {
        this.packGroups.forEach(Group::enable);
    }

    public void updateGroupsStates() {
        block9: {
            this.packGroups.forEach(grp -> grp.containedBlocks.forEach(block -> block.setEnabled(grp.isEnabled())));
            List<Group.SerializableGroup> serializableGroupToWrite = this.packGroups.stream().map(Group::getAsRecord).toList();
            if (this.isFolder) {
                try (BufferedWriter writer = Files.newBufferedWriter(Path.of("%s/ctm_selector.json".formatted(this.packPath), new String[0]), new OpenOption[0]);){
                    new GsonBuilder().setPrettyPrinting().create().toJson(serializableGroupToWrite, (Appendable)writer);
                    break block9;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            HashMap<String, byte[]> h = new HashMap<String, byte[]>(1);
            byte[] b = CTMSelector.toByteArray(serializableGroupToWrite);
            h.put("ctm_selector.json", b);
            Utils.writeBytesToZip(Path.of(this.packPath, new String[0]).toString(), h);
        }
    }

    public static byte @NotNull [] toByteArray(@NotNull List<Group.SerializableGroup> groups) {
        ArrayList<String> s = new ArrayList<String>(groups.size());
        for (Group.SerializableGroup sc : groups) {
            StringBuilder sbFiles = new StringBuilder();
            sbFiles.append("[\n");
            for (int i = 0; i < sc.propertiesFilesPaths().size(); ++i) {
                sbFiles.append(String.format("\t\t\t\"%s\"", sc.propertiesFilesPaths().get(i)));
                if (i == sc.propertiesFilesPaths().size() - 1) continue;
                sbFiles.append(",\n");
            }
            sbFiles.append("\n\t\t]");
            s.add(String.format("\t{\n\t\t\"group_name\": \"%s\",\n\t\t\"properties_files\": %s,\n\t\t\"icon_path\": \"%s\",\n\t\t\"enabled\": %b,\n\t\t\"button_tooltip\": \"%s\"\n\t}", sc.groupName(), sbFiles, sc.iconPath(), sc.isEnabled(), sc.buttonTooltip() == null ? "" : sc.buttonTooltip()));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        for (int i = 0; i < s.size(); ++i) {
            sb.append((String)s.get(i));
            if (i == s.size() - 1) continue;
            sb.append(",\n");
        }
        sb.append("\n]");
        return sb.toString().getBytes();
    }
}

