/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.ctms.textures;

import com.google.gson.annotations.SerializedName;
import fr.aeldit.ctms.VersionUtils;
import fr.aeldit.ctms.textures.entryTypes.CTMBlock;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Group {
    public final String groupName;
    private final String iconPath;
    private final ArrayList<String> identifierLikePropertiesPaths;
    private boolean isEnabled;
    public final class_2561 buttonTooltip;
    private final List<Path> propertiesFilesPaths;
    private final List<ZipEntry> propertiesFilesZipEntries;
    public final class_2960 identifier;
    public final List<CTMBlock> containedBlocks = new ArrayList<CTMBlock>();

    public Group(@NotNull SerializableGroup serializableGroup, boolean isFolder, String packPath) {
        this.groupName = serializableGroup.groupName;
        this.buttonTooltip = class_2561.method_30163((String)serializableGroup.buttonTooltip);
        this.isEnabled = serializableGroup.isEnabled;
        if (isFolder) {
            this.propertiesFilesPaths = new ArrayList<Path>();
            this.propertiesFilesZipEntries = null;
            for (String path : serializableGroup.propertiesFilesPaths) {
                Path path1 = Path.of("%s/assets/%s".formatted(packPath, path.replace(":", "/")), new String[0]);
                if (Files.exists(path1, new LinkOption[0]) && path1.toFile().isDirectory()) {
                    this.getPropertiesFilesPathsInDir(path1.toFile());
                    continue;
                }
                if (!path.endsWith(".properties")) continue;
                this.propertiesFilesPaths.add(path1);
            }
        } else {
            this.propertiesFilesPaths = null;
            this.propertiesFilesZipEntries = new ArrayList<ZipEntry>();
            try (ZipFile zipFile = new ZipFile(packPath);){
                for (String s : serializableGroup.propertiesFilesPaths) {
                    String pathInZip = "assets/%s".formatted(s.replace(":", "/"));
                    if (pathInZip.endsWith(".properties")) {
                        ZipEntry entry = this.getZipEntryByName(zipFile.entries(), pathInZip);
                        if (entry == null) continue;
                        this.propertiesFilesZipEntries.add(entry);
                        continue;
                    }
                    this.getPropertiesFilesInZipFolder(zipFile.entries(), pathInZip);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.identifierLikePropertiesPaths = serializableGroup.propertiesFilesPaths;
        this.iconPath = serializableGroup.iconPath;
        if (this.iconPath.contains(":")) {
            String[] split = this.iconPath.split(":");
            this.identifier = VersionUtils.getIdentifier(split[0], split[1]);
        } else {
            this.identifier = VersionUtils.getIdentifier("textures/misc/unknown_pack.png");
        }
    }

    private void getPropertiesFilesPathsInDir(File dir) {
        Stack<File> fileStack = new Stack<File>();
        fileStack.push(dir);
        while (!fileStack.empty()) {
            File[] files;
            File currentFile = (File)fileStack.pop();
            if (!currentFile.isDirectory() || (files = currentFile.listFiles()) == null) continue;
            for (File file : files) {
                if (file.isDirectory()) {
                    fileStack.push(file);
                    continue;
                }
                if (!file.isFile() || !file.toString().endsWith(".properties")) continue;
                this.propertiesFilesPaths.add(Path.of(file.toString(), new String[0]));
            }
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void enable() {
        this.isEnabled = true;
    }

    public void toggle() {
        this.isEnabled = !this.isEnabled;
    }

    public SerializableGroup getAsRecord() {
        return new SerializableGroup(this.groupName, this.identifierLikePropertiesPaths, this.iconPath, this.isEnabled, this.buttonTooltip.getString());
    }

    public void addContainedBlock(CTMBlock ctmBlock) {
        if (this.propertiesFilesPaths != null && this.propertiesFilesPaths.contains(Path.of(ctmBlock.propertiesPath, new String[0]))) {
            this.containedBlocks.add(ctmBlock);
        } else if (this.propertiesFilesZipEntries != null && this.propertiesFilesZipEntries.stream().map(ZipEntry::getName).toList().contains(ctmBlock.propertiesPath)) {
            this.containedBlocks.add(ctmBlock);
        }
    }

    private void getPropertiesFilesInZipFolder(@NotNull Enumeration<? extends ZipEntry> entries, @NotNull String folder) {
        if (this.propertiesFilesZipEntries != null) {
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(folder) || !entry.getName().endsWith(".properties")) continue;
                this.propertiesFilesZipEntries.add(entry);
            }
        }
    }

    @Nullable
    private ZipEntry getZipEntryByName(@NotNull Enumeration<? extends ZipEntry> entries, @NotNull String name) {
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!name.equals(entry.getName())) continue;
            return entry;
        }
        return null;
    }

    public record SerializableGroup(@SerializedName(value="group_name") @NotNull String groupName, @SerializedName(value="properties_files") @NotNull ArrayList<String> propertiesFilesPaths, @SerializedName(value="icon_path") @NotNull String iconPath, @SerializedName(value="enabled") boolean isEnabled, @SerializedName(value="button_tooltip") @Nullable String buttonTooltip) {
    }
}

