/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.ctms.textures;

import fr.aeldit.ctms.Utils;
import fr.aeldit.ctms.VersionUtils;
import fr.aeldit.ctms.textures.CTMPacks;
import fr.aeldit.ctms.textures.entryTypes.CTMBlock;
import fr.aeldit.ctms.textures.entryTypes.CTMPack;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public class FilesHandling {
    private final String[] types = new String[]{"matchBlocks", "matchTiles", "ctmDisabled", "ctmTilesDisabled"};

    public void load() {
        Utils.CTM_PACKS = new CTMPacks();
        if (!Files.exists(Utils.RESOURCE_PACKS_DIR, new LinkOption[0])) {
            return;
        }
        File[] files = Utils.RESOURCE_PACKS_DIR.toFile().listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                CTMPack ctmPack = new CTMPack(file, this.getAllBlocksInPack(file));
                Utils.CTM_PACKS.add(ctmPack);
                continue;
            }
            if (!file.isFile() || !file.getName().endsWith(".zip")) continue;
            try (ZipFile zipFile = new ZipFile(file);){
                CTMPack ctmPack = new CTMPack(zipFile, this.getAllBlocksInPack(zipFile));
                Utils.CTM_PACKS.add(ctmPack);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @NotNull
    private HashMap<String, List<CTMBlock>> getAllBlocksInPack(@NotNull File file) {
        File[] rootFiles = file.listFiles();
        if (rootFiles == null) {
            return new HashMap<String, List<CTMBlock>>();
        }
        for (File rootFile : rootFiles) {
            if (!"assets".equals(rootFile.getName())) continue;
            File[] assetsFiles = rootFile.listFiles();
            if (assetsFiles == null) {
                return new HashMap<String, List<CTMBlock>>();
            }
            HashMap<String, List<CTMBlock>> allBlocks = new HashMap<String, List<CTMBlock>>();
            for (File namespaceDir : assetsFiles) {
                if (!namespaceDir.isDirectory()) continue;
                allBlocks.put(namespaceDir.getName(), this.getCTMBlocksForNamespace(namespaceDir));
            }
            return allBlocks;
        }
        return new HashMap<String, List<CTMBlock>>();
    }

    @NotNull
    private HashMap<String, List<CTMBlock>> getAllBlocksInPack(@NotNull ZipFile zipFile) throws IOException {
        HashMap<String, List<CTMBlock>> namespaceBlocks = new HashMap<String, List<CTMBlock>>();
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String fhStr = String.valueOf(entry);
            if (!fhStr.contains("optifine/ctm/") || fhStr.chars().filter(c -> c == 47).count() <= 2L) continue;
            String namespace = fhStr.split("/")[1];
            if (!namespaceBlocks.containsKey(namespace)) {
                namespaceBlocks.put(namespace, new ArrayList());
            }
            if (!fhStr.endsWith(".properties")) continue;
            Properties props = new Properties();
            props.load(zipFile.getInputStream(entry));
            if (props.isEmpty() || !props.containsKey("method")) continue;
            String method = props.getProperty("method");
            if (Stream.of("ctm", "ctm_compact", "horizontal", "vertical", "horizontal+vertical", "vertical+horizontal", "top", "random", "repeat", "fixed").noneMatch(s -> s.equals(method))) continue;
            List<CTMBlock> ctmBlocks = namespaceBlocks.get(namespace);
            class_2960 identifier = this.getIdentifierFor(props, zipFile, this.getParentFileHeader(fhStr), namespace);
            if (props.containsKey(this.types[0])) {
                ctmBlocks.add(new CTMBlock(String.valueOf(props.get(this.types[0])).split(" ")[0], identifier, true, false, fhStr));
                continue;
            }
            if (props.containsKey(this.types[1])) {
                ctmBlocks.add(new CTMBlock(String.valueOf(props.get(this.types[1])).split(" ")[0], identifier, true, true, fhStr));
                continue;
            }
            if (props.containsKey(this.types[2])) {
                ctmBlocks.add(new CTMBlock(String.valueOf(props.get(this.types[2])).split(" ")[0], identifier, false, false, fhStr));
                continue;
            }
            if (!props.containsKey(this.types[3])) continue;
            ctmBlocks.add(new CTMBlock(String.valueOf(props.get(this.types[3])).split(" ")[0], identifier, false, true, fhStr));
        }
        return namespaceBlocks;
    }

    @NotNull
    private List<CTMBlock> getCTMBlocksForNamespace(@NotNull File namespaceDir) {
        ArrayList<CTMBlock> ctmBlocks = new ArrayList<CTMBlock>();
        Stack<File> filesStack = new Stack<File>();
        filesStack.push(namespaceDir);
        String namespace = namespaceDir.getName();
        while (!filesStack.empty()) {
            File fileOrDir = (File)filesStack.pop();
            File[] files = fileOrDir.listFiles();
            if (files == null) continue;
            for (File file : files) {
                if (file.isDirectory()) {
                    filesStack.push(file);
                    continue;
                }
                if (!file.isFile() || !file.getName().endsWith(".properties")) continue;
                Properties props = new Properties();
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    props.load(fileInputStream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (props.isEmpty() || !props.containsKey("method")) continue;
                String method = props.getProperty("method");
                if (Stream.of("ctm", "ctm_compact", "horizontal", "vertical", "horizontal+vertical", "vertical+horizontal", "top", "random", "repeat", "fixed").noneMatch(s -> s.equals(method))) continue;
                class_2960 identifier = this.getIdentifierFor(props, file.getParentFile(), namespace);
                String filePath = String.valueOf(file);
                if (props.containsKey(this.types[0])) {
                    ctmBlocks.add(new CTMBlock(String.valueOf(props.get(this.types[0])).split(" ")[0], identifier, true, false, filePath));
                    continue;
                }
                if (props.containsKey(this.types[1])) {
                    ctmBlocks.add(new CTMBlock(String.valueOf(props.get(this.types[1])).split(" ")[0], identifier, true, true, filePath));
                    continue;
                }
                if (props.containsKey(this.types[2])) {
                    ctmBlocks.add(new CTMBlock(String.valueOf(props.get(this.types[2])).split(" ")[0], identifier, false, false, filePath));
                    continue;
                }
                if (!props.containsKey(this.types[3])) continue;
                ctmBlocks.add(new CTMBlock(String.valueOf(props.get(this.types[3])).split(" ")[0], identifier, false, true, filePath));
            }
        }
        return ctmBlocks;
    }

    private class_2960 getIdentifierFor(@NotNull Properties properties, @NotNull File parentFile, String namespace) {
        File[] neighborFiles = parentFile.listFiles();
        if (neighborFiles == null || !properties.containsKey("tiles")) {
            return VersionUtils.getIdentifier("unknown");
        }
        String tile = String.valueOf(properties.get("tiles")).split(" ")[0];
        class_2960 identifier = VersionUtils.getIdentifier("unknown");
        if (StringUtils.isNumeric((CharSequence)tile)) {
            int image = Integer.parseInt(tile);
            String pngFile = "%d.png".formatted(image);
            if (Arrays.stream(neighborFiles).anyMatch(file -> pngFile.equals(file.getName()))) {
                identifier = Arrays.stream(neighborFiles).filter(file -> pngFile.equals(file.getName())).findFirst().map(file -> VersionUtils.getIdentifier(namespace, this.getIdentifierLikePathFrom(namespace, file.getPath()))).orElse(identifier);
            }
        } else if (tile.contains("/")) {
            LoggerFactory.getLogger((String)"ctms").warn("Full path identifiers are not implemented yet");
        } else if (tile.contains("-") && !tile.matches("[A-Za-z]+")) {
            int firstImage = Integer.parseInt(tile.split("-")[0]);
            String pngFile = "%d.png".formatted(firstImage);
            if (Arrays.stream(neighborFiles).anyMatch(file -> pngFile.equals(file.getName()))) {
                identifier = Arrays.stream(neighborFiles).filter(file -> pngFile.equals(file.getName())).findFirst().map(file -> VersionUtils.getIdentifier(namespace, this.getIdentifierLikePathFrom(namespace, file.getPath()))).orElse(identifier);
            }
        } else if (tile.endsWith(".png")) {
            if (Arrays.stream(neighborFiles).anyMatch(file -> tile.equals(file.getName()))) {
                identifier = Arrays.stream(neighborFiles).filter(file -> tile.equals(file.getName())).findFirst().map(file -> VersionUtils.getIdentifier(namespace, this.getIdentifierLikePathFrom(namespace, file.getPath()))).orElse(identifier);
            }
        } else if (StringUtils.isAsciiPrintable((CharSequence)tile)) {
            if (Stream.of(">", "<", ":", "\"", "/", "\\", "|", "?", "*").noneMatch(tile::contains)) {
                String pngFile = "%s.png".formatted(tile);
                if (Arrays.stream(neighborFiles).anyMatch(file -> pngFile.equals(file.getName()))) {
                    identifier = Arrays.stream(neighborFiles).filter(file -> pngFile.equals(file.getName())).findFirst().map(file -> VersionUtils.getIdentifier(namespace, this.getIdentifierLikePathFrom(namespace, file.getPath()))).orElse(identifier);
                }
            }
        }
        return identifier;
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    private class_2960 getIdentifierFor(@NotNull Properties properties, @NotNull ZipFile zipFile, String parentFh, String namespace) {
        String tile;
        if (!properties.containsKey("tiles")) {
            return VersionUtils.getIdentifier("unknown");
        }
        String tiles = String.valueOf(properties.get("tiles"));
        String string = tile = tiles.contains(" ") ? tiles.split(" ")[0] : tiles;
        if (StringUtils.isNumeric((CharSequence)tile)) {
            int image = Integer.parseInt(tile);
            String pngFile = "%d.png".formatted(image);
            Enumeration<? extends ZipEntry> es = zipFile.entries();
            while (es.hasMoreElements()) {
                if (!String.valueOf(es.nextElement()).contains("assets/%s/%s%s".formatted(namespace, parentFh, pngFile))) continue;
                return VersionUtils.getIdentifier(namespace, "%s%s".formatted(parentFh, pngFile));
            }
        } else if (tile.contains("/")) {
            LoggerFactory.getLogger((String)"ctms").warn("Full path identifiers are not implemented yet");
        } else if (tile.contains("-") && !tile.matches("[A-Za-z]+")) {
            int firstImage = Integer.parseInt(tile.split("-")[0]);
            String pngFile = "%d.png".formatted(firstImage);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!String.valueOf(entry).contains("assets/%s/%s%s".formatted(namespace, parentFh, pngFile))) continue;
                return VersionUtils.getIdentifier(namespace, "%s%s".formatted(parentFh, pngFile));
            }
        } else if (tile.endsWith(".png")) {
            ZipEntry entry = zipFile.getEntry("assets/%s/%s%s".formatted(namespace, parentFh, tile));
            if (entry != null) {
                return VersionUtils.getIdentifier(namespace, entry.toString().replaceFirst("assets/%s/".formatted(namespace), ""));
            }
        } else if (StringUtils.isAsciiPrintable((CharSequence)tile)) {
            ZipEntry entry;
            if (Stream.of(">", "<", ":", "\"", "/", "\\", "|", "?", "*").noneMatch(tile::contains) && (entry = zipFile.getEntry("assets/%s/%s%s.png".formatted(namespace, parentFh, tile))) != null) {
                return VersionUtils.getIdentifier(namespace, entry.toString().replaceFirst("assets/%s/".formatted(namespace), ""));
            }
        }
        return VersionUtils.getIdentifier("unknown");
    }

    @NotNull
    private String getIdentifierLikePathFrom(String namespace, @NotNull String path) {
        ArrayList<String> split = new ArrayList<String>(List.of(path.split(Utils.PATH_SEPARATOR)));
        StringBuilder sb = new StringBuilder();
        int splitSize = split.size();
        for (int i = split.lastIndexOf(namespace) + 1; i < splitSize; ++i) {
            sb.append((String)split.get(i));
            if (i == splitSize - 1) continue;
            sb.append("/");
        }
        return String.valueOf(sb);
    }

    @NotNull
    private String getParentFileHeader(@NotNull String fhStr) {
        StringBuilder sb = new StringBuilder();
        String[] split = fhStr.split("/");
        if (split.length < 2) {
            return "";
        }
        for (int i = 2; i < split.length - 1; ++i) {
            sb.append(split[i]).append("/");
        }
        return String.valueOf(sb);
    }

    public void updatePropertiesFiles(@NotNull CTMPack ctmPack) {
        Path packPath = Path.of("%s/resourcepacks/%s".formatted(FabricLoader.getInstance().getGameDir(), ctmPack.getName()), new String[0]);
        if (!Files.exists(packPath, new LinkOption[0])) {
            return;
        }
        boolean changed = false;
        if (ctmPack.isFolder) {
            for (CTMBlock ctmBlock : ctmPack.getCTMBlocks()) {
                Properties properties = new Properties();
                File file = Path.of(ctmBlock.propertiesPath, new String[0]).toFile();
                try (FileInputStream fis = new FileInputStream(file);){
                    properties.load(fis);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (ctmBlock.isEnabled() != this.isBlockEnabled(properties, ctmBlock.blockName)) {
                    changed = true;
                    this.setBlockInPropertiesToAppropriateState(properties, ctmBlock);
                }
                try (FileOutputStream fos = new FileOutputStream(file);){
                    this.removeEmptyKeys(properties);
                    properties.store(fos, null);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (changed) {
                class_310.method_1551().method_1521();
            }
        } else {
            HashMap<String, byte[]> headersBytes = new HashMap<String, byte[]>();
            try (ZipFile zipFile = new ZipFile(packPath.toString());){
                for (CTMBlock ctmBlock : ctmPack.getCTMBlocks()) {
                    ZipEntry entry = zipFile.getEntry(ctmBlock.propertiesPath);
                    if (entry == null) continue;
                    Properties properties = new Properties();
                    properties.load(zipFile.getInputStream(entry));
                    if (ctmBlock.isEnabled() != this.isBlockEnabled(properties, ctmBlock.blockName)) {
                        changed = true;
                        this.setBlockInPropertiesToAppropriateState(properties, ctmBlock);
                    }
                    if (!changed) continue;
                    this.removeEmptyKeys(properties);
                    byte[] tmp = String.valueOf(properties).replace("{", "").replace("}", "").replace(", ", "\n").getBytes();
                    headersBytes.put(entry.toString(), tmp);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (!headersBytes.isEmpty()) {
                class_310.method_1551().method_1520().method_49428("file/%s".formatted(ctmPack.getName()));
                class_310.method_1551().method_1521();
                Utils.writeBytesToZip(String.valueOf(packPath), headersBytes);
                class_310.method_1551().method_1520().method_49427("file/%s".formatted(ctmPack.getName()));
                class_310.method_1551().method_1521();
            }
        }
    }

    private boolean isBlockEnabled(@NotNull Properties properties, String blockName) {
        return properties.containsKey(this.types[0]) && String.valueOf(properties.get(this.types[0])).equals(blockName) || properties.containsKey(this.types[1]) && String.valueOf(properties.get(this.types[1])).equals(blockName);
    }

    private void setBlockInPropertiesToAppropriateState(@NotNull Properties properties, @NotNull CTMBlock ctmBlock) {
        if (ctmBlock.isEnabled()) {
            if (ctmBlock.isTile) {
                properties.put(this.types[1], ctmBlock.blockName);
                properties.remove(this.types[3]);
            } else {
                properties.put(this.types[0], ctmBlock.blockName);
                properties.remove(this.types[2]);
            }
        } else if (ctmBlock.isTile) {
            properties.put(this.types[3], ctmBlock.blockName);
            properties.remove(this.types[1]);
        } else {
            properties.put(this.types[2], ctmBlock.blockName);
            properties.remove(this.types[0]);
        }
    }

    private void removeEmptyKeys(@NotNull Properties properties) {
        Arrays.stream(this.types).filter(properties::containsKey).filter(type -> properties.getProperty((String)type).isEmpty()).forEachOrdered(properties::remove);
    }
}

