/*
 * Decompiled with CFR 0.152.
 */
package fr.aeldit.ctms;

import fr.aeldit.ctms.textures.CTMPacks;
import fr.aeldit.ctms.textures.FilesHandling;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;

public abstract class Utils {
    public static final String CTMS_MODID = "ctms";
    public static final String PATH_SEPARATOR = SystemUtils.IS_OS_WINDOWS ? "\\\\" : "/";
    public static final FilesHandling TEXTURES_HANDLING = new FilesHandling();
    public static CTMPacks CTM_PACKS;
    public static final Path RESOURCE_PACKS_DIR;

    public static void writeBytesToZip(String packPath, @NotNull HashMap<String, byte[]> headersBytes) {
        HashMap<String, String> env = new HashMap<String, String>(1);
        env.put("create", "true");
        Path path = Paths.get(packPath, new String[0]);
        URI uri = URI.create("jar:" + String.valueOf(path.toUri()));
        try (FileSystem fs = FileSystems.newFileSystem(uri, env);){
            for (Map.Entry<String, byte[]> entry : headersBytes.entrySet()) {
                Path nf = fs.getPath(entry.getKey(), new String[0]);
                Files.write(nf, entry.getValue(), StandardOpenOption.CREATE);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static String getPrettyString(String @NotNull [] s) {
        StringBuilder stringBuilder = new StringBuilder();
        int index = 0;
        for (String str : s) {
            if (str.length() < 2) continue;
            stringBuilder.append(str.substring(0, 1).toUpperCase()).append(str.substring(1));
            if (index < s.length - 1) {
                stringBuilder.append(" ");
            }
            ++index;
        }
        return stringBuilder.toString();
    }

    static {
        RESOURCE_PACKS_DIR = FabricLoader.getInstance().getGameDir().resolve("resourcepacks");
    }
}

