/*
 * Decompiled with CFR 0.152.
 */
package oas.work.vein_vantage.procedures;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;

@EventBusSubscriber
public class StartClearingStrikeProcedure {
    private static final ResourceLocation CLEARING_STRIKE_ENCHANTMENT_ID = ResourceLocation.parse((String)"vein_vantage:clearing_strike");

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        StartClearingStrikeProcedure.execute((Event)event, event.getLevel(), event.getPos(), (Entity)event.getPlayer());
    }

    public static void execute(LevelAccessor world, BlockPos pos, Entity entity) {
        StartClearingStrikeProcedure.execute(null, world, pos, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, BlockPos pos, Entity entity) {
        BlockPos effectCenter;
        int radius;
        if (entity == null || world.isClientSide()) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        ItemStack mainHandItemStack = livingEntity.getMainHandItem();
        int enchantmentLevel = mainHandItemStack.getEnchantmentLevel((Holder)world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)CLEARING_STRIKE_ENCHANTMENT_ID)));
        if (enchantmentLevel <= 0) {
            return;
        }
        Block originalBlockType = world.getBlockState(pos).getBlock();
        Direction playerLookDirection = StartClearingStrikeProcedure.getPlayerOrientationDirection((Entity)livingEntity);
        HashSet<BlockPos> blocksToBreakSet = new HashSet<BlockPos>();
        if (enchantmentLevel == 1) {
            radius = 1;
            effectCenter = pos;
        } else {
            radius = 2;
            effectCenter = pos.above();
        }
        blocksToBreakSet.addAll(StartClearingStrikeProcedure.getBlocksInPlane(effectCenter, playerLookDirection, radius));
        for (BlockPos targetPos : blocksToBreakSet) {
            BlockState targetBlockState;
            if (targetPos.equals((Object)pos) || (targetBlockState = world.getBlockState(targetPos)).isAir() || !(targetBlockState.getDestroySpeed((BlockGetter)world, targetPos) >= 0.0f) || targetBlockState.getBlock() != originalBlockType || !(world instanceof Level)) continue;
            Level level = (Level)world;
            level.destroyBlock(targetPos, true, entity);
        }
    }

    private static Direction getPlayerOrientationDirection(Entity entity) {
        return Direction.orderedByNearest((Entity)entity)[0];
    }

    private static List<BlockPos> getBlocksInPlane(BlockPos basePos, Direction playerOrientationDirection, int radius) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        Direction.Axis facingAxis = playerOrientationDirection.getAxis();
        for (int offset1 = -radius; offset1 <= radius; ++offset1) {
            for (int offset2 = -radius; offset2 <= radius; ++offset2) {
                int dx = 0;
                int dy = 0;
                int dz = 0;
                switch (facingAxis) {
                    case X: {
                        dy = offset1;
                        dz = offset2;
                        break;
                    }
                    case Y: {
                        dx = offset1;
                        dz = offset2;
                        break;
                    }
                    case Z: {
                        dx = offset1;
                        dy = offset2;
                    }
                }
                positions.add(basePos.offset(dx, dy, dz));
            }
        }
        return positions;
    }
}

