/*
 * Decompiled with CFR 0.152.
 */
package oas.work.vein_vantage.procedures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;
import oas.work.vein_vantage.VeinVantageMod;

@EventBusSubscriber
public class StartVeinSweepProcedure {
    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        StartVeinSweepProcedure.execute((Event)event, event.getLevel(), event.getPos().getX(), event.getPos().getY(), event.getPos().getZ(), (Entity)event.getPlayer());
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        StartVeinSweepProcedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null || world.isClientSide()) {
            return;
        }
        if (!entity.isShiftKeyDown()) {
            return;
        }
        int enchantLevel = 0;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ItemStack mainHand = living.getMainHandItem();
            enchantLevel = mainHand.getEnchantmentLevel((Holder)world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.parse((String)"vein_vantage:vein_sweep"))));
        }
        if (enchantLevel <= 0) {
            return;
        }
        int maxBlocks = enchantLevel * 12;
        BlockPos startPos = BlockPos.containing((double)x, (double)y, (double)z);
        BlockState targetState = world.getBlockState(startPos);
        Block targetBlock = targetState.getBlock();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> toVisit = new LinkedList<BlockPos>();
        ArrayList<BlockPos> orderedVein = new ArrayList<BlockPos>();
        visited.add(startPos);
        toVisit.add(startPos);
        while (!toVisit.isEmpty() && orderedVein.size() < maxBlocks) {
            BlockPos current = (BlockPos)toVisit.poll();
            if (world.getBlockState(current).getBlock() != targetBlock) continue;
            orderedVein.add(current);
            for (BlockPos neighbor : StartVeinSweepProcedure.getAdjacent(current)) {
                if (visited.contains(neighbor) || world.getBlockState(neighbor).getBlock() != targetBlock) continue;
                visited.add(neighbor);
                toVisit.add(neighbor);
            }
        }
        int delayPerBlock = 1;
        for (int i = 0; i < orderedVein.size(); ++i) {
            BlockPos posToBreak = (BlockPos)orderedVein.get(i);
            int delay = i * delayPerBlock;
            VeinVantageMod.queueServerWork(delay, () -> {
                BlockState stateToBreak = world.getBlockState(posToBreak);
                Block.dropResources((BlockState)stateToBreak, (LevelAccessor)world, (BlockPos)posToBreak, null);
                world.destroyBlock(posToBreak, false);
            });
        }
    }

    private static List<BlockPos> getAdjacent(BlockPos pos) {
        return Arrays.asList(pos.north(), pos.south(), pos.east(), pos.west(), pos.above(), pos.below());
    }
}

