/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.minecraft;

import com.gtnewhorizon.gtnhlib.util.map.ItemStackMap;
import com.mitchej123.hodgepodge.Common;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={FurnaceRecipes.class})
public abstract class MixinFurnaceRecipes {
    @Shadow
    private Map<ItemStack, ItemStack> smeltingList = new ItemStackMap(false);
    @Shadow
    private Map<ItemStack, Float> experienceList = new ItemStackMap(false);

    @Overwrite
    public void func_151394_a(ItemStack input, ItemStack stack, float experience) {
        if (this.getSmeltingResult(input) != null) {
            Common.log.debug("Overwriting smelting recipe for input: {} and output {} with {}", new Object[]{input, this.getSmeltingResult(input), stack});
        }
        this.smeltingList.put(input, stack);
        this.experienceList.put(stack, Float.valueOf(experience));
    }

    @Overwrite
    public ItemStack getSmeltingResult(ItemStack stack) {
        return this.smeltingList.get(stack);
    }

    @Overwrite
    public float func_151398_b(ItemStack stack) {
        if (stack == null || stack.getItem() == null) {
            return 0.0f;
        }
        float exp = stack.getItem().getSmeltingExperience(stack);
        if (exp == -1.0f) {
            exp = this.experienceList.getOrDefault(stack, Float.valueOf(0.0f)).floatValue();
        }
        return exp;
    }
}

