/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.fml;

import com.gtnewhorizon.gtnhlib.util.FilesUtil;
import com.mitchej123.hodgepodge.client.bettermodlist.InfoButton;
import com.mitchej123.hodgepodge.client.bettermodlist.SortType;
import com.mitchej123.hodgepodge.config.TweaksConfig;
import com.mitchej123.hodgepodge.mixins.interfaces.IGuiModList;
import com.mitchej123.hodgepodge.mixins.interfaces.IGuiScrollingList;
import com.mitchej123.hodgepodge.mixins.interfaces.IGuiSlotModList;
import cpw.mods.fml.client.GuiModList;
import cpw.mods.fml.client.GuiSlotModList;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={GuiModList.class})
public class MixinGuiModList
extends GuiScreen
implements IGuiModList {
    @Shadow(remap=false)
    private ArrayList<ModContainer> mods;
    @Shadow(remap=false)
    private int listWidth;
    @Shadow(remap=false)
    private ModContainer selectedMod;
    @Shadow(remap=false)
    private int selected;
    @Shadow(remap=false)
    private GuiSlotModList modList;
    @Unique
    private final int hodgepodge$numButtons = SortType.values().length;
    @Unique
    private String hodgepodge$lastFilterText = "";
    @Unique
    private GuiTextField hodgepodge$search;
    @Unique
    private boolean hodgepodge$sorted = false;
    private SortType hodgepodge$sortType = SortType.values()[TweaksConfig.defaultModSort];
    @Unique
    int hodgepodge$urlX = 0;
    @Unique
    int hodgepodge$urlY = 0;
    @Unique
    String hodgepodge$urlStr;

    @Inject(method={"initGui"}, at={@At(value="TAIL")})
    public void onInitGui(CallbackInfo ci) {
        int hodgepodge$xPosition = ((IGuiScrollingList)this.modList).hodgepodge$getBottom() + 17;
        this.hodgepodge$search = new GuiTextField(this.fontRendererObj, 12, hodgepodge$xPosition, this.listWidth - 4, 14);
        this.hodgepodge$search.setFocused(true);
        this.hodgepodge$search.setCanLoseFocus(true);
        for (GuiButton button : this.buttonList) {
            if (button.id == 6) {
                int min = this.listWidth + 10;
                int max = this.width;
                button.xPosition = (min + max) / 2 - button.width / 2;
                button.yPosition += 10;
                continue;
            }
            if (button.id != 20 && button.id != 21) continue;
            button.yPosition += 10;
        }
        int buttonWidth = this.listWidth / this.hodgepodge$numButtons;
        int hodgepodge$buttonMargin = 1;
        int x = 10;
        int y = 10;
        for (SortType type : SortType.values()) {
            GuiButton button = new GuiButton(type.getButtonID(), x, y, buttonWidth - hodgepodge$buttonMargin, 20, type.getName());
            this.buttonList.add(button);
            x += buttonWidth + hodgepodge$buttonMargin;
        }
        this.buttonList.add(new InfoButton(this.hodgepodge$GuiModList()));
        this.hodgepodge$reloadMods();
        this.hodgepodge$updateButtonStates();
    }

    public void updateScreen() {
        super.updateScreen();
        this.hodgepodge$search.updateCursorCounter();
        if (!this.hodgepodge$search.getText().equals(this.hodgepodge$lastFilterText)) {
            this.hodgepodge$reloadMods();
            this.hodgepodge$sorted = false;
        }
        if (!this.hodgepodge$sorted) {
            this.hodgepodge$reloadMods();
            Collections.sort(this.mods, this.hodgepodge$sortType.getComparator());
            this.selected = ((IGuiScrollingList)this.modList).hodgepodge$setSelectedIndex(this.mods.indexOf(this.selectedMod));
            this.hodgepodge$sorted = true;
        }
    }

    @Unique
    private void hodgepodge$reloadMods() {
        ArrayList<ModContainer> mods = ((IGuiSlotModList)this.modList).hodgepodge$getMods();
        mods.clear();
        for (ModContainer m2 : Loader.instance().getActiveModList()) {
            if (!m2.getName().toLowerCase(Locale.US).contains(this.hodgepodge$search.getText().toLowerCase(Locale.US)) || m2.getMetadata().parentMod != null) continue;
            mods.add(m2);
        }
        this.mods = mods;
        this.hodgepodge$lastFilterText = this.hodgepodge$search.getText();
    }

    @Inject(method={"actionPerformed"}, at={@At(value="TAIL")})
    public void onActionPerformed(GuiButton button, CallbackInfo ci) {
        SortType type;
        if (button.id == 30) {
            this.hodgepodge$search.setText("");
            this.hodgepodge$reloadMods();
            for (ModContainer m2 : this.mods) {
                if (!m2.getName().equals("Hodgepodge")) continue;
                this.selectedMod = m2;
                this.selected = ((IGuiScrollingList)this.modList).hodgepodge$setSelectedIndex(this.mods.indexOf(m2));
            }
        }
        if ((type = SortType.getTypeForButton(button.id)) != null) {
            this.hodgepodge$sorted = false;
            this.hodgepodge$sortType = type;
            this.hodgepodge$updateButtonStates();
            this.mods = ((IGuiSlotModList)this.modList).hodgepodge$getMods();
        }
    }

    @Unique
    private void hodgepodge$updateButtonStates() {
        for (GuiButton button : this.buttonList) {
            if (SortType.getTypeForButton(button.id) != null) {
                button.enabled = true;
            }
            if (button.id != this.hodgepodge$sortType.getButtonID()) continue;
            button.enabled = false;
        }
    }

    @Inject(method={"drawScreen"}, at={@At(value="TAIL")})
    public void onDrawScreen(int mouseX, int mouseY, float partialTicks, CallbackInfo ci) {
        int Bottom = ((IGuiScrollingList)this.modList).hodgepodge$getBottom();
        int Right = ((IGuiScrollingList)this.modList).hodgepodge$getRight();
        String text = "Search:";
        int x = (10 + Right) / 2 - this.fontRendererObj.getStringWidth(text) / 2;
        this.fontRendererObj.drawString(text, x, Bottom + 5, 0xFFFFFF);
        this.hodgepodge$search.drawTextBox();
    }

    @ModifyArgs(method={"drawScreen"}, at=@At(value="INVOKE", target="Lcpw/mods/fml/client/GuiModList;drawLine(Ljava/lang/String;II)I", remap=false))
    private void replaceDrawLineArgs(Args args) {
        String line = (String)args.get(0);
        int offset = (Integer)args.get(1);
        int shifty = (Integer)args.get(2);
        if (line != null && line.startsWith("URL: ")) {
            this.hodgepodge$urlX = offset + this.fontRendererObj.getStringWidth("URL: ");
            this.hodgepodge$urlY = shifty;
            this.hodgepodge$urlStr = line.substring("URL: ".length());
            args.set(0, (Object)line.replace("URL: ", "URL: \u00a79\u00a7n"));
        }
    }

    public void mouseClicked(int x, int y, int button) {
        super.mouseClicked(x, y, button);
        this.hodgepodge$search.mouseClicked(x, y, button);
        if (button == 1 && x >= this.hodgepodge$search.xPosition && x < this.hodgepodge$search.xPosition + this.hodgepodge$search.width && y >= this.hodgepodge$search.yPosition && y < this.hodgepodge$search.yPosition + this.hodgepodge$search.height) {
            this.hodgepodge$search.setText("");
        }
        if (this.hodgepodge$urlStr != null) {
            int height = this.fontRendererObj.FONT_HEIGHT;
            int width = this.fontRendererObj.getStringWidth(this.hodgepodge$urlStr);
            if (x >= this.hodgepodge$urlX && x <= this.hodgepodge$urlX + width && y >= this.hodgepodge$urlY && y <= this.hodgepodge$urlY + height) {
                try {
                    FilesUtil.openUri((URI)new URI(this.hodgepodge$urlStr));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void keyTyped(char p_73869_1_, int p_73869_2_) {
        super.keyTyped(p_73869_1_, p_73869_2_);
        this.hodgepodge$search.textboxKeyTyped(p_73869_1_, p_73869_2_);
    }

    @Unique
    private GuiModList hodgepodge$GuiModList() {
        return (GuiModList)this;
    }

    @Override
    public ModContainer hodgepodge$selectedMod() {
        return this.selectedMod;
    }
}

