/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.minecraft;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={BlockGrass.class})
public class MixinBlockGrass {
    @Overwrite
    public void updateTick(World worldIn, int x, int y, int z, Random random) {
        if (worldIn.isRemote) {
            return;
        }
        int blockLightValue = worldIn.getBlockLightValue(x, y + 1, z);
        if (blockLightValue < 4 && worldIn.getBlockLightOpacity(x, y + 1, z) > 2) {
            worldIn.setBlock(x, y, z, Blocks.dirt);
        } else if (blockLightValue >= 9) {
            for (int i = 0; i < 4; ++i) {
                int targetX = x + random.nextInt(3) - 1;
                int targetY = y + random.nextInt(5) - 3;
                int targetZ = z + random.nextInt(3) - 1;
                if (targetX == x && targetZ == z && (targetY == y || targetY == y - 1) || !worldIn.blockExists(targetX, targetY, targetZ) || worldIn.getBlock(targetX, targetY, targetZ) != Blocks.dirt || worldIn.getBlockMetadata(targetX, targetY, targetZ) != 0 || worldIn.getBlockLightValue(targetX, targetY + 1, targetZ) < 4 || worldIn.getBlockLightOpacity(targetX, targetY + 1, targetZ) > 2) continue;
                worldIn.setBlock(targetX, targetY, targetZ, (Block)Blocks.grass);
            }
        }
    }
}

