/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.minecraft;

import com.mitchej123.hodgepodge.config.FixesConfig;
import java.io.IOException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={PacketBuffer.class})
public class MixinPacketBuffer {
    @Unique
    private static final short MAGIC_LENGTH_IS_INT = Short.MAX_VALUE;

    @Overwrite
    public NBTTagCompound readNBTTagCompoundFromBuffer() throws IOException {
        PacketBuffer self = (PacketBuffer)this;
        int shortLength = self.readShort();
        if (shortLength < 0) {
            return null;
        }
        int realLength = shortLength == Short.MAX_VALUE ? self.readInt() : shortLength;
        byte[] buffer = new byte[realLength];
        self.readBytes(buffer);
        return CompressedStreamTools.func_152457_a((byte[])buffer, (NBTSizeTracker)new NBTSizeTracker((long)FixesConfig.maxNetworkNbtSizeLimit));
    }

    @Overwrite
    public void writeNBTTagCompoundToBuffer(NBTTagCompound nbt) throws IOException {
        PacketBuffer self = (PacketBuffer)this;
        if (nbt == null) {
            self.writeShort(-1);
        } else {
            byte[] buffer = CompressedStreamTools.compress((NBTTagCompound)nbt);
            if (buffer.length >= Short.MAX_VALUE) {
                self.writeShort(Short.MAX_VALUE);
                self.writeInt(buffer.length);
            } else {
                self.writeShort(buffer.length);
            }
            self.writeBytes(buffer);
        }
    }
}

