/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.minecraft;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PotionEffect.class})
public class MixinPotionEffect {
    @Shadow
    int potionID;

    @Inject(method={"<init>(IIIZ)V"}, at={@At(value="RETURN")})
    public void hodgepodge$primaryConstructor(int p_i1576_1_, int p_i1576_2_, int p_i1576_3_, boolean p_i1576_4_, CallbackInfo ci) {
        this.potionID = p_i1576_1_ & 0xFF;
    }

    @Overwrite
    public static PotionEffect readCustomPotionEffectFromNBT(NBTTagCompound tag) {
        int potion = tag.getByte("Id") & 0xFF;
        if (potion >= 0 && potion < Potion.potionTypes.length && Potion.potionTypes[potion] != null) {
            byte amplifier = tag.getByte("Amplifier");
            int duration = tag.getInteger("Duration");
            boolean ambient = tag.getBoolean("Ambient");
            return new PotionEffect(potion, duration, (int)amplifier, ambient);
        }
        return null;
    }
}

