/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.hooks;

import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.client.FMLFileResourcePack;
import cpw.mods.fml.common.ModContainer;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.IMetadataSerializer;
import net.minecraft.util.ResourceLocation;

public class IC2ResourcePack
implements IResourcePack {
    private final IResourcePack fallbackResourcePack;
    private final ZipFile zipFile;

    public IC2ResourcePack(ModContainer container) {
        this.fallbackResourcePack = new FMLFileResourcePack(container);
        try {
            this.zipFile = new ZipFile(container.getSource());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getInputStream(ResourceLocation rl) throws IOException {
        String locationName = IC2ResourcePack.locationToName(rl);
        ZipEntry zipentry = this.zipFile.getEntry(locationName);
        if (zipentry != null) {
            return this.zipFile.getInputStream(zipentry);
        }
        return this.fallbackResourcePack.getInputStream(rl);
    }

    public boolean resourceExists(ResourceLocation rl) {
        return this.zipFile.getEntry(IC2ResourcePack.locationToName(rl)) != null || this.fallbackResourcePack.resourceExists(rl);
    }

    public Set<String> getResourceDomains() {
        return ImmutableSet.of((Object)"ic2", (Object)"minecraft");
    }

    public IMetadataSection getPackMetadata(IMetadataSerializer p_135058_1_, String p_135058_2_) throws IOException {
        return this.fallbackResourcePack.getPackMetadata(p_135058_1_, p_135058_2_);
    }

    public BufferedImage getPackImage() throws IOException {
        return this.fallbackResourcePack.getPackImage();
    }

    public String getPackName() {
        return "IC2 resource pack injected by Hodgepodge";
    }

    private static String locationToName(ResourceLocation rl) {
        return String.format("%s/%s", rl.getResourceDomain(), rl.getResourcePath().replace(".lang", ".properties"));
    }
}

