/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.client;

import com.mitchej123.hodgepodge.client.HodgepodgeClient;
import com.mitchej123.hodgepodge.config.DebugConfig;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class DebugScreenHandler {
    public static final DebugScreenHandler INSTANCE = new DebugScreenHandler();
    private final boolean is64bit = DebugScreenHandler.check64bit();
    private final String javaVersion = System.getProperty("java.version");
    private final String javaVendor = System.getProperty("java.vendor");
    private final String gpuName = GL11.glGetString((int)7937);
    private final String glVersion = GL11.glGetString((int)7938);
    private final String osArch = System.getProperty("os.arch");
    private final String osName = System.getProperty("os.name");
    private final String osVersion = System.getProperty("os.version");

    private DebugScreenHandler() {
    }

    @SubscribeEvent
    public void onRenderGameOverlayTextEvent(RenderGameOverlayEvent.Text event) {
        if (Minecraft.getMinecraft().gameSettings.showDebugInfo) {
            int offset = event.right.isEmpty() ? 0 : 2;
            event.right.add(offset, null);
            event.right.add(1 + offset, "Java: " + this.javaVersion + (this.is64bit ? " 64bit (" : " 32bit (") + this.javaVendor + ")");
            event.right.add(2 + offset, "GPU: " + this.gpuName);
            event.right.add(3 + offset, "OpenGL: " + this.glVersion);
            event.right.add(4 + offset, "CPU Cores: " + Runtime.getRuntime().availableProcessors());
            event.right.add(5 + offset, "OS: " + this.osName + " (" + this.osVersion + ", " + this.osArch + ")");
            if (DebugConfig.renderDebug) {
                event.right.add(6 + offset, null);
                if (DebugConfig.renderDebug) {
                    event.right.add(8 + offset, "renderDebugMode: " + HodgepodgeClient.renderDebugMode);
                }
            }
        }
    }

    private static boolean check64bit() {
        String[] keys;
        for (String key : keys = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"}) {
            String value = System.getProperty(key);
            if (value == null || !value.contains("64")) continue;
            return true;
        }
        return false;
    }
}

