/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.asm.transformers.mc;

import com.gtnewhorizon.gtnhlib.asm.ClassConstantPoolParser;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class SpeedupObjectIntIdentityMapTransformer
implements IClassTransformer {
    public static final String OBJECT_INT_IDENTITY_MAP = "net/minecraft/util/ObjectIntIdentityMap";
    public static final String OBJECT_INT_IDENTITY_MAP_OBF = "ct";
    public static final String PROPER_OBJECT_INT_IDENTITY_MAP = "com/mitchej123/hodgepodge/util/ProperObjectIntIdentityMap";
    private static final ClassConstantPoolParser cstPoolParser = new ClassConstantPoolParser(new String[]{"net/minecraft/util/ObjectIntIdentityMap", "ct"});
    private static final Logger LOGGER = LogManager.getLogger((String)"SpeedupObjectIntIdentityMapTransformer");
    public static final String INIT = "<init>";
    public static final String EMPTY_DESC = "()V";

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (!cstPoolParser.find(basicClass, true)) {
            return basicClass;
        }
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        boolean changed = this.transformClassNode(transformedName, cn);
        if (changed) {
            ClassWriter cw = new ClassWriter(1);
            cn.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        return basicClass;
    }

    public boolean transformClassNode(String transformedName, ClassNode cn) {
        if (cn == null) {
            return false;
        }
        if (transformedName.startsWith("com.mitchej123.hodgepodge.util")) {
            return false;
        }
        boolean changed = false;
        boolean objectIntIdentityMapInit = false;
        for (MethodNode mn : cn.methods) {
            for (AbstractInsnNode node : mn.instructions.toArray()) {
                if (node.getOpcode() == 187 && node instanceof TypeInsnNode) {
                    TypeInsnNode tNode = (TypeInsnNode)node;
                    if (objectIntIdentityMapInit || !tNode.desc.equals(OBJECT_INT_IDENTITY_MAP) && !tNode.desc.equals(OBJECT_INT_IDENTITY_MAP_OBF)) continue;
                    objectIntIdentityMapInit = true;
                    LOGGER.info("Found ObjectIntIdentityMap instantiation in " + transformedName + "." + mn.name);
                    mn.instructions.insertBefore((AbstractInsnNode)tNode, (AbstractInsnNode)new TypeInsnNode(187, PROPER_OBJECT_INT_IDENTITY_MAP));
                    mn.instructions.remove((AbstractInsnNode)tNode);
                    changed = true;
                    continue;
                }
                if (node.getOpcode() != 183 || !(node instanceof MethodInsnNode)) continue;
                MethodInsnNode mNode = (MethodInsnNode)node;
                if (!mNode.name.equals(INIT) || !mNode.desc.equals(EMPTY_DESC) || !objectIntIdentityMapInit || !mNode.owner.equals(OBJECT_INT_IDENTITY_MAP) && !mNode.owner.equals(OBJECT_INT_IDENTITY_MAP_OBF)) continue;
                objectIntIdentityMapInit = false;
                LOGGER.info("Found ObjectIntIdentityMap constructor call in " + transformedName + "." + mn.name);
                mn.instructions.insertBefore((AbstractInsnNode)mNode, (AbstractInsnNode)new MethodInsnNode(183, PROPER_OBJECT_INT_IDENTITY_MAP, INIT, EMPTY_DESC, false));
                mn.instructions.remove((AbstractInsnNode)mNode);
            }
        }
        if (objectIntIdentityMapInit) {
            throw new IllegalStateException("Failed to transform " + transformedName + " due to missing constructor call");
        }
        return changed;
    }
}

